/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DITAAttrUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TopicIdParser;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ChunkTopicParser
extends AbstractXMLWriter {
    private static final String ATTR_CHUNK_VALUE_SELECT_BRANCH = "select-branch";
    private static final String ATTR_CHUNK_VALUE_TO_CONTENT = "to-content";
    private static final String ATTR_CHUNK_VALUE_SELECT_TOPIC = "select-topic";
    private static final String ATTR_CHUNK_VALUE_SELECT_DOCUMENT = "select-document";
    private static final String PI_END = "?>";
    private static final String PI_WORKDIR_HEAD = "<?workdir ";
    private LinkedHashMap<String, String> changeTable = null;
    private Hashtable<String, String> conflictTable = null;
    private Element elem = null;
    private Element topicDoc = null;
    private boolean separate = false;
    private String filePath = null;
    private String currentParsingFile = null;
    private String outputFile = null;
    private final Stack<String> outputFileNameStack;
    private String targetTopicId = null;
    private String selectMethod = "select-document";
    private boolean include = false;
    private boolean skip = false;
    private int includelevel = 0;
    private int skipLevel = 0;
    private final Set<String> topicSpecSet = new HashSet<String>(16);
    private boolean insideCDATA = false;
    private boolean needResolveEntity = true;
    private boolean startFromFirstTopic = false;
    private final XMLReader reader;
    private Writer output = null;
    private final Stack<Writer> fileWriterStack = new Stack();
    private final Stack<Element> stubStack = new Stack();
    private Element stub = null;
    private Element siblingStub = null;
    private String ditaext = null;
    private Set<String> topicID;
    private final Set<String> copyto;
    private final Set<String> copytoSource;
    private final Map<String, String> copytotarget2source;
    private Map<String, String> currentParsingFileTopicIDChangeTable;
    private final Random random;
    private static final String ditaarchNSValue = "http://dita.oasis-open.org/architecture/2005/";

    public ChunkTopicParser() {
        this.outputFileNameStack = new Stack();
        this.topicID = new HashSet<String>();
        this.copyto = new HashSet<String>();
        this.copytoSource = new HashSet<String>();
        this.copytotarget2source = new HashMap<String, String>();
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
        this.random = new Random();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.include && this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.include = false;
        this.skip = false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block10: {
            if (this.skip && this.skipLevel > 0) {
                --this.skipLevel;
            } else if (this.skip) {
                this.include = true;
                this.skip = false;
                this.skipLevel = 0;
            }
            if (this.include) {
                try {
                    --this.includelevel;
                    if (this.includelevel >= 0) {
                        this.output.write("<");
                        this.output.write("/");
                        this.output.write(qName);
                        this.output.write(">");
                    }
                    if (this.includelevel == 0 && !ATTR_CHUNK_VALUE_SELECT_DOCUMENT.equals(this.selectMethod)) {
                        this.include = false;
                    }
                    if (!this.topicSpecSet.contains(qName) || !this.separate || this.fileWriterStack.isEmpty()) break block10;
                    try {
                        this.output.close();
                    }
                    catch (IOException e) {
                        this.logger.logError(e.getMessage(), e);
                    }
                    this.output = this.fileWriterStack.pop();
                    this.outputFile = this.outputFileNameStack.pop();
                    this.stub.getParentNode().removeChild(this.stub);
                    this.stub = this.stubStack.pop();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.include) {
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.include || "workdir".equalsIgnoreCase(target) || "workdir-uri".equals(target) || "path2project".equalsIgnoreCase(target)) {
            try {
                String pi = data != null ? target + " " + data : target;
                this.output.write("<?" + pi + "?" + ">");
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void setContent(Content content) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.include) {
            try {
                this.output.write(StringUtils.getEntity(name));
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (ATTR_CHUNK_VALUE_SELECT_DOCUMENT.equals(this.selectMethod)) {
            if (this.currentParsingFile.equals(this.outputFile)) {
                this.include = true;
                this.skip = false;
                this.skipLevel = 0;
            } else {
                this.include = false;
                this.startFromFirstTopic = true;
                this.skip = false;
                this.skipLevel = 0;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        String idValue = atts.getValue("id");
        if (this.skip && this.skipLevel > 0) {
            ++this.skipLevel;
        }
        try {
            if (classValue != null && Constants.TOPIC_TOPIC.matches(classValue)) {
                this.topicSpecSet.add(qName);
                String id = atts.getValue("id");
                Element element = DITAAttrUtils.getInstance().searchForNode(this.topicDoc, id, "id", Constants.TOPIC_TOPIC.matcher);
                if (this.separate && this.include && !ATTR_CHUNK_VALUE_SELECT_TOPIC.equals(this.selectMethod)) {
                    this.fileWriterStack.push(this.output);
                    this.outputFileNameStack.push(this.outputFile);
                    String newFileName = FileUtils.resolveFile(this.filePath, idValue + this.ditaext);
                    if (StringUtils.isEmptyString(idValue) || FileUtils.fileExists(newFileName)) {
                        String t = newFileName;
                        newFileName = FileUtils.resolveFile(this.filePath, this.generateFilename());
                        this.conflictTable.put(newFileName, t);
                    }
                    this.outputFile = newFileName;
                    this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(newFileName), "UTF-8");
                    this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    if (Constants.OS_NAME.toLowerCase().indexOf("windows") == -1) {
                        this.output.write(PI_WORKDIR_HEAD + this.filePath + PI_END);
                    } else {
                        this.output.write("<?workdir /" + this.filePath + PI_END);
                    }
                    this.output.write("<?workdir-uri " + new File(this.filePath).toURI().toString() + PI_END);
                    this.changeTable.put(newFileName, newFileName);
                    if (idValue != null) {
                        this.changeTable.put(this.currentParsingFile + "#" + idValue, newFileName + "#" + idValue);
                    } else {
                        this.changeTable.put(this.currentParsingFile, newFileName);
                    }
                    Element newChild = this.elem.getOwnerDocument().createElement(Constants.MAP_TOPICREF.localName);
                    newChild.setAttribute("href", FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", newFileName));
                    newChild.setAttribute("class", Constants.MAP_TOPICREF.toString());
                    newChild.setAttribute("xtrf", "generated_by_chunk");
                    this.createTopicMeta(element, newChild);
                    if (this.stub != null) {
                        if (this.includelevel == 0 && this.siblingStub != null) {
                            this.siblingStub.getParentNode().insertBefore(newChild, this.siblingStub);
                        } else {
                            this.stub.getParentNode().insertBefore(newChild, this.stub);
                        }
                        this.stubStack.push(this.stub);
                        this.stub = (Element)this.stub.cloneNode(false);
                        newChild.appendChild(this.stub);
                    }
                }
                if (this.include && ATTR_CHUNK_VALUE_SELECT_TOPIC.equals(this.selectMethod)) {
                    this.include = false;
                    this.skipLevel = 1;
                    this.skip = true;
                } else if (this.include) {
                    if (!this.currentParsingFile.equals(this.outputFile)) {
                        if (idValue != null) {
                            this.changeTable.put(this.currentParsingFile + "#" + idValue, this.outputFile + "#" + idValue);
                        } else {
                            this.changeTable.put(this.currentParsingFile, this.outputFile);
                        }
                    }
                } else if (this.skip) {
                    this.skipLevel = 1;
                } else if (!this.include && idValue != null && (idValue.equals(this.targetTopicId) || this.startFromFirstTopic)) {
                    this.include = true;
                    this.includelevel = 0;
                    this.skip = false;
                    this.skipLevel = 0;
                    this.startFromFirstTopic = false;
                    if (!this.currentParsingFile.equals(this.outputFile)) {
                        this.changeTable.put(this.currentParsingFile + "#" + idValue, this.outputFile + "#" + idValue);
                    }
                }
            }
            if (this.include) {
                ++this.includelevel;
                this.output.write("<");
                this.output.write(qName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attrName = atts.getQName(i);
                    String attrValue = atts.getValue(i);
                    attrValue = StringUtils.escapeXML(attrValue);
                    if ("id".equals(attrName) && Constants.TOPIC_TOPIC.matches(classValue)) {
                        if (this.topicID.contains(attrValue)) {
                            String oldAttrValue = attrValue;
                            attrValue = this.generateID();
                            this.topicID.add(attrValue);
                            String tmpVal = this.changeTable.get(this.currentParsingFile + "#" + idValue);
                            if (tmpVal != null && tmpVal.equalsIgnoreCase(this.outputFile + "#" + idValue)) {
                                this.changeTable.put(this.currentParsingFile + "#" + idValue, this.outputFile + "#" + attrValue);
                            }
                            if ((tmpVal = this.changeTable.get(this.currentParsingFile)) != null && tmpVal.equalsIgnoreCase(this.outputFile + "#" + idValue)) {
                                this.changeTable.put(this.currentParsingFile, this.outputFile + "#" + attrValue);
                            }
                            this.currentParsingFileTopicIDChangeTable.put(oldAttrValue, attrValue);
                        } else {
                            this.topicID.add(attrValue);
                        }
                    }
                    if ("href".equals(attrName)) {
                        this.output.write(" ");
                        this.output.write("href");
                        this.output.write("=");
                        this.output.write("\"");
                        if (this.checkHREF(atts)) {
                            String relative = FileUtils.getRelativePath(this.outputFile, this.currentParsingFile);
                            if (this.conflictTable.containsKey(this.outputFile)) {
                                String realoutputfile = this.conflictTable.get(this.outputFile);
                                relative = FileUtils.getRelativePath(realoutputfile, this.currentParsingFile);
                            }
                            if (attrValue.startsWith("#")) {
                                this.output.write(relative + attrValue);
                            } else if (relative.indexOf("/") != -1) {
                                relative = relative.substring(0, relative.lastIndexOf("/"));
                                this.output.write(FileUtils.resolveTopic(relative, attrValue));
                            } else {
                                this.output.write(attrValue);
                            }
                        } else {
                            this.output.write(attrValue);
                        }
                        this.output.write("\"");
                        continue;
                    }
                    this.output.write(" ");
                    this.output.write(attrName);
                    this.output.write("=");
                    this.output.write("\"");
                    this.output.write(attrValue);
                    this.output.write("\"");
                }
                if (classValue != null && Constants.TOPIC_TOPIC.matches(classValue) && atts.getValue("xmlns:ditaarch") == null) {
                    this.output.write(" ");
                    this.output.write("xmlns:ditaarch");
                    this.output.write("=");
                    this.output.write("\"");
                    this.output.write(ditaarchNSValue);
                    this.output.write("\"");
                }
                this.output.write(">");
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private String generateID() {
        return "unique_" + this.random.nextInt(Integer.MAX_VALUE);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.include) {
            try {
                this.needResolveEntity = StringUtils.checkEntity(name);
                if (!this.needResolveEntity) {
                    this.output.write(StringUtils.getEntity(name));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            this.insideCDATA = true;
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void write(String filename) throws DITAOTException {
        this.filePath = filename;
        this.needResolveEntity = true;
        if (!this.separate) {
            this.output = new StringWriter();
            this.processChunk(this.elem, null);
        } else {
            this.separateChunk(this.elem);
        }
        if (!this.copyto.isEmpty()) {
            this.updateList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList() {
        try {
            Job job = new Job(new File(this.filePath));
            Set<String> copytosourcelist = job.getSet("copytosourcelist");
            Map<String, String> copytotarget2sourcemaplist = job.getCopytoMap();
            this.copytoSource.addAll(copytosourcelist);
            this.copytotarget2source.putAll(copytotarget2sourcemaplist);
            job.setSet("copytosourcelist", this.copytoSource);
            job.setMap("copytotarget2sourcemaplist", this.copytotarget2source);
            job.write();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void separateChunk(Element element) {
        block46: {
            boolean dotchunk;
            Writer tempOutput;
            block45: {
                String hrefValue = element.getAttribute("href");
                String copytoValue = element.getAttribute("copy-to");
                String scopeValue = element.getAttribute("scope");
                String parseFilePath = null;
                tempOutput = null;
                String chunkValue = element.getAttribute("chunk");
                String processRoleValue = element.getAttribute("processing-role");
                dotchunk = false;
                parseFilePath = copytoValue.length() != 0 && !chunkValue.contains(ATTR_CHUNK_VALUE_TO_CONTENT) ? (hrefValue.indexOf("#") != -1 ? copytoValue + hrefValue.substring(hrefValue.indexOf("#")) : copytoValue) : hrefValue;
                if (copytoValue.length() != 0 && chunkValue.contains(ATTR_CHUNK_VALUE_TO_CONTENT)) {
                    this.copyto.add(copytoValue);
                    if (hrefValue.indexOf("#") != -1) {
                        this.copytoSource.add(hrefValue.substring(0, hrefValue.indexOf("#")));
                        this.copytotarget2source.put(copytoValue, hrefValue.substring(0, hrefValue.indexOf("#")));
                    } else {
                        this.copytoSource.add(hrefValue);
                        this.copytotarget2source.put(copytoValue, hrefValue);
                    }
                }
                if (StringUtils.isEmptyString(parseFilePath) || "external".equalsIgnoreCase(scopeValue) || "resource-only".equalsIgnoreCase(processRoleValue)) break block45;
                this.currentParsingFile = FileUtils.resolveFile(this.filePath, parseFilePath);
                String outputFileName = null;
                String id = null;
                String firstTopicID = null;
                if (parseFilePath.contains("#") && parseFilePath.indexOf("#") < parseFilePath.length() - 1) {
                    id = parseFilePath.substring(parseFilePath.indexOf("#") + 1);
                    if (chunkValue.contains(ATTR_CHUNK_VALUE_SELECT_BRANCH)) {
                        outputFileName = FileUtils.resolveFile(this.filePath, id + this.ditaext);
                        this.targetTopicId = id;
                        this.startFromFirstTopic = false;
                        this.selectMethod = ATTR_CHUNK_VALUE_SELECT_BRANCH;
                    } else if (chunkValue.contains(ATTR_CHUNK_VALUE_SELECT_DOCUMENT)) {
                        firstTopicID = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, parseFilePath));
                        this.topicDoc = DITAAttrUtils.getInstance().getTopicDoc(FileUtils.resolveFile(this.filePath, parseFilePath));
                        if (!StringUtils.isEmptyString(firstTopicID)) {
                            outputFileName = FileUtils.resolveFile(this.filePath, firstTopicID + this.ditaext);
                            this.targetTopicId = firstTopicID;
                        } else {
                            outputFileName = this.currentParsingFile + ".chunk";
                            dotchunk = true;
                            this.targetTopicId = null;
                        }
                        this.selectMethod = ATTR_CHUNK_VALUE_SELECT_DOCUMENT;
                    } else {
                        outputFileName = FileUtils.resolveFile(this.filePath, id + this.ditaext);
                        this.targetTopicId = id;
                        this.startFromFirstTopic = false;
                        this.selectMethod = ATTR_CHUNK_VALUE_SELECT_TOPIC;
                    }
                } else {
                    firstTopicID = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, parseFilePath));
                    this.topicDoc = DITAAttrUtils.getInstance().getTopicDoc(FileUtils.resolveFile(this.filePath, parseFilePath));
                    if (!StringUtils.isEmptyString(firstTopicID)) {
                        outputFileName = FileUtils.resolveFile(this.filePath, firstTopicID + this.ditaext);
                        this.targetTopicId = firstTopicID;
                    } else {
                        outputFileName = this.currentParsingFile + ".chunk";
                        dotchunk = true;
                        this.targetTopicId = null;
                    }
                    this.selectMethod = ATTR_CHUNK_VALUE_SELECT_DOCUMENT;
                }
                if (copytoValue.length() != 0) {
                    outputFileName = FileUtils.resolveFile(this.filePath, copytoValue);
                }
                if (FileUtils.fileExists(outputFileName)) {
                    String t = outputFileName;
                    outputFileName = FileUtils.resolveFile(this.filePath, this.generateFilename());
                    this.conflictTable.put(outputFileName, t);
                    dotchunk = false;
                }
                tempOutput = this.output;
                this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), "UTF-8");
                this.outputFile = outputFileName;
                if (!dotchunk) {
                    this.changeTable.put(FileUtils.resolveTopic(this.filePath, parseFilePath), outputFileName + (id == null ? "" : "#" + id));
                    this.changeTable.put(outputFileName, outputFileName);
                }
                if (StringUtils.isEmptyString(firstTopicID)) {
                    element.setAttribute("href", FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", outputFileName) + (id == null ? "" : "#" + id));
                } else {
                    element.setAttribute("href", FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", outputFileName) + "#" + firstTopicID);
                }
                this.include = false;
                this.stub = element.getOwnerDocument().createElement("stub");
                this.siblingStub = element.getOwnerDocument().createElement("stub");
                if (element.hasChildNodes()) {
                    NodeList list = element.getElementsByTagName(Constants.MAP_TOPICMETA.localName);
                    if (list.getLength() > 0) {
                        Node node = list.item(0);
                        Node nextSibling = node.getNextSibling();
                        if (nextSibling == null) {
                            node.getParentNode().appendChild(this.stub);
                        } else {
                            node.getParentNode().insertBefore(this.stub, nextSibling);
                        }
                    } else {
                        element.insertBefore(this.stub, element.getFirstChild());
                    }
                } else {
                    element.appendChild(this.stub);
                }
                if (element.getNextSibling() != null) {
                    element.getParentNode().insertBefore(this.siblingStub, element.getNextSibling());
                } else {
                    element.getParentNode().appendChild(this.siblingStub);
                }
                this.reader.setErrorHandler(new DITAOTXMLErrorHandler(this.currentParsingFile, this.logger));
                this.reader.parse(new File(this.currentParsingFile).toURI().toString());
                this.output.flush();
                this.stub.getParentNode().removeChild(this.stub);
                this.siblingStub.getParentNode().removeChild(this.siblingStub);
            }
            try {
                if (this.output != null) {
                    this.output.close();
                    if (dotchunk && !new File(this.currentParsingFile).delete()) {
                        this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                    }
                    if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                        this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                    }
                }
                this.output = tempOutput;
            }
            catch (Exception ex) {
                this.logger.logError(ex.getMessage(), ex);
            }
            break block46;
            catch (Exception e) {
                try {
                    this.logger.logError(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.output != null) {
                            this.output.close();
                            if (dotchunk && !new File(this.currentParsingFile).delete()) {
                                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                            }
                            if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                            }
                        }
                        this.output = tempOutput;
                    }
                    catch (Exception ex) {
                        this.logger.logError(ex.getMessage(), ex);
                    }
                    throw throwable;
                }
                try {
                    if (this.output != null) {
                        this.output.close();
                        if (dotchunk && !new File(this.currentParsingFile).delete()) {
                            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                        }
                        if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", this.currentParsingFile, this.outputFile).toString());
                        }
                    }
                    this.output = tempOutput;
                }
                catch (Exception ex) {
                    this.logger.logError(ex.getMessage(), ex);
                }
            }
        }
    }

    private String generateFilename() {
        return "Chunk" + this.random.nextInt(Integer.MAX_VALUE) + this.ditaext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunk(Element element, String outputFile) {
        block43: {
            String hrefValue = element.getAttribute("href");
            String chunkValue = element.getAttribute("chunk");
            String copytoValue = element.getAttribute("copy-to");
            String scopeValue = element.getAttribute("scope");
            String classValue = element.getAttribute("class");
            String processRoleValue = element.getAttribute("processing-role");
            String id = element.getAttribute("id");
            String navtitle = element.getAttribute("navtitle");
            String parseFilePath = null;
            String outputFileName = outputFile;
            Writer tempWriter = new StringWriter();
            Set<Object> tempTopicID = new HashSet();
            this.targetTopicId = null;
            this.selectMethod = ATTR_CHUNK_VALUE_SELECT_DOCUMENT;
            this.include = false;
            boolean needWriteDitaTag = true;
            try {
                parseFilePath = copytoValue.length() != 0 && !chunkValue.contains(ATTR_CHUNK_VALUE_TO_CONTENT) ? (hrefValue.indexOf("#") != -1 ? copytoValue + hrefValue.substring(hrefValue.indexOf("#")) : copytoValue) : hrefValue;
                if (copytoValue.length() != 0 && chunkValue.contains(ATTR_CHUNK_VALUE_TO_CONTENT) && hrefValue.length() != 0) {
                    this.copyto.add(copytoValue);
                    if (hrefValue.indexOf("#") != -1) {
                        this.copytoSource.add(hrefValue.substring(0, hrefValue.indexOf("#")));
                        this.copytotarget2source.put(copytoValue, hrefValue.substring(0, hrefValue.indexOf("#")));
                    } else {
                        this.copytoSource.add(hrefValue);
                        this.copytotarget2source.put(copytoValue, hrefValue);
                    }
                }
                if (StringUtils.isEmptyString(classValue)) break block43;
                if (!(Constants.MAPGROUP_D_TOPICGROUP.matches(classValue) || StringUtils.isEmptyString(parseFilePath) || "external".equalsIgnoreCase(scopeValue))) {
                    String firstTopicID;
                    if (chunkValue.indexOf(ATTR_CHUNK_VALUE_TO_CONTENT) != -1) {
                        tempWriter = this.output;
                        tempTopicID = this.topicID;
                        this.output = new StringWriter();
                        this.topicID = new HashSet<String>();
                        if (Constants.MAP_MAP.matches(classValue)) {
                            outputFileName = FileUtils.resolveFile(this.filePath, parseFilePath);
                            needWriteDitaTag = false;
                        } else {
                            String firstTopic;
                            outputFileName = copytoValue.length() != 0 ? FileUtils.resolveFile(this.filePath, copytoValue) : (hrefValue.length() != 0 ? (chunkValue.contains(ATTR_CHUNK_VALUE_SELECT_TOPIC) || chunkValue.contains(ATTR_CHUNK_VALUE_SELECT_BRANCH) ? (hrefValue.contains("#") && hrefValue.indexOf("#") < hrefValue.length() - 1 ? FileUtils.resolveFile(this.filePath, hrefValue.substring(hrefValue.indexOf("#") + 1) + this.ditaext) : (!StringUtils.isEmptyString(firstTopic = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, hrefValue))) ? FileUtils.resolveFile(this.filePath, firstTopic + this.ditaext) : FileUtils.resolveFile(this.filePath, hrefValue))) : FileUtils.resolveFile(this.filePath, hrefValue)) : FileUtils.resolveFile(this.filePath, this.generateFilename()));
                        }
                        if (FileUtils.fileExists(outputFileName) && !Constants.MAP_MAP.matches(classValue)) {
                            String t = outputFileName;
                            outputFileName = FileUtils.resolveFile(this.filePath, this.generateFilename());
                            this.conflictTable.put(outputFileName, t);
                        }
                        this.changeTable.put(outputFileName, outputFileName);
                    }
                    this.outputFile = outputFileName;
                    String path = FileUtils.resolveTopic(this.filePath, parseFilePath);
                    String newpath = null;
                    newpath = path.indexOf("#") != -1 ? outputFileName + path.substring(path.indexOf("#")) : (!StringUtils.isEmptyString(firstTopicID = this.getFirstTopicId(path)) ? outputFileName + "#" + firstTopicID : outputFileName);
                    this.changeTable.put(path, newpath);
                    element.setAttribute("href", FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", newpath));
                    if (parseFilePath.indexOf("#") != -1) {
                        this.targetTopicId = parseFilePath.substring(parseFilePath.indexOf("#") + 1);
                    }
                    if (chunkValue.indexOf("select") != -1) {
                        int endIndex = chunkValue.indexOf(" ", chunkValue.indexOf("select"));
                        this.selectMethod = endIndex == -1 ? chunkValue.substring(chunkValue.indexOf("select")) : chunkValue.substring(chunkValue.indexOf("select"), endIndex);
                        if ((ATTR_CHUNK_VALUE_SELECT_TOPIC.equals(this.selectMethod) || ATTR_CHUNK_VALUE_SELECT_BRANCH.equals(this.selectMethod)) && this.targetTopicId == null) {
                            this.selectMethod = ATTR_CHUNK_VALUE_SELECT_DOCUMENT;
                        }
                    }
                    String tempPath = this.currentParsingFile;
                    this.currentParsingFile = FileUtils.resolveFile(this.filePath, parseFilePath);
                    if (!"resource-only".equalsIgnoreCase(processRoleValue)) {
                        this.currentParsingFileTopicIDChangeTable = new HashMap<String, String>();
                        this.reader.parse(new File(this.currentParsingFile).toURI().toString());
                        if (this.currentParsingFileTopicIDChangeTable.size() > 0) {
                            String new_elementid;
                            String old_elementid;
                            String href = element.getAttribute("href");
                            String pathtoElem = (href = FileUtils.separatorsToUnix(href)).contains("#") ? href.substring(href.indexOf("#") + 1) : "";
                            String string = old_elementid = pathtoElem.contains("/") ? pathtoElem.substring(0, pathtoElem.indexOf("/")) : pathtoElem;
                            if (old_elementid.length() > 0 && (new_elementid = this.currentParsingFileTopicIDChangeTable.get(old_elementid)) != null && new_elementid.length() > 0) {
                                href = href.replaceFirst("#" + old_elementid, "#" + new_elementid);
                                element.setAttribute("href", href);
                            }
                        }
                        this.currentParsingFileTopicIDChangeTable = null;
                    }
                    this.currentParsingFile = tempPath;
                }
                if (outputFileName == null) {
                    if (!StringUtils.isEmptyString(copytoValue)) {
                        outputFileName = FileUtils.resolveFile(this.filePath, copytoValue);
                    } else if (!StringUtils.isEmptyString(id)) {
                        outputFileName = FileUtils.resolveFile(this.filePath, id + this.ditaext);
                    } else {
                        outputFileName = FileUtils.resolveFile(this.filePath, this.generateFilename());
                        if (FileUtils.fileExists(outputFileName) && !Constants.MAP_MAP.matches(classValue)) {
                            String t = outputFileName;
                            outputFileName = FileUtils.resolveFile(this.filePath, this.generateFilename());
                            this.conflictTable.put(outputFileName, t);
                        }
                    }
                    if (element.hasChildNodes() || !StringUtils.isEmptyString(navtitle)) {
                        DITAAttrUtils utils = DITAAttrUtils.getInstance();
                        String navtitleValue = null;
                        String shortDescValue = null;
                        navtitleValue = utils.getChildElementValueOfTopicmeta(element, Constants.TOPIC_NAVTITLE.matcher);
                        shortDescValue = utils.getChildElementValueOfTopicmeta(element, Constants.MAP_SHORTDESC.matcher);
                        if (navtitleValue == null) {
                            navtitleValue = navtitle;
                        }
                        this.changeTable.put(outputFileName, outputFileName);
                        if (!StringUtils.isEmptyString(navtitleValue)) {
                            element.setAttribute("href", FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", outputFileName));
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("<topic id=\"topic\" class=\"- topic/topic \">").append("<title class=\"- topic/title \">").append(navtitleValue).append("</title>");
                            if (shortDescValue != null) {
                                buffer.append("<shortdesc class=\"- topic/shortdesc \">").append(shortDescValue).append("</shortdesc>");
                            }
                            buffer.append("</topic>");
                            StringReader rder = new StringReader(buffer.toString());
                            InputSource source = new InputSource(rder);
                            String tempPath = this.currentParsingFile;
                            this.currentParsingFile = outputFileName;
                            parseFilePath = outputFileName;
                            this.reader.parse(source);
                            this.currentParsingFile = tempPath;
                        }
                    }
                }
                if (element.hasChildNodes()) {
                    StringWriter temp = (StringWriter)this.output;
                    this.output = new StringWriter();
                    NodeList children = element.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 1 || ((Element)current).getAttribute("class").indexOf(Constants.MAP_TOPICREF.matcher) == -1) continue;
                        this.processChunk((Element)current, outputFileName);
                    }
                    StringBuffer parentResult = temp.getBuffer();
                    if (parentResult.length() > 0 && !StringUtils.isEmptyString(parseFilePath) && !"resource-only".equalsIgnoreCase(processRoleValue)) {
                        int insertpoint = parentResult.lastIndexOf("</");
                        int end = parentResult.indexOf(">", insertpoint);
                        if (insertpoint == -1 || end == -1) {
                            this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ033E", hrefValue).toString());
                        } else {
                            if ("dita".equalsIgnoreCase(parentResult.substring(insertpoint, end).trim())) {
                                insertpoint = parentResult.lastIndexOf("</", insertpoint);
                            }
                            parentResult.insert(insertpoint, ((StringWriter)this.output).getBuffer());
                        }
                    } else {
                        parentResult.append(((StringWriter)this.output).getBuffer());
                    }
                    this.output = temp;
                }
                if (chunkValue.indexOf(ATTR_CHUNK_VALUE_TO_CONTENT) == -1) break block43;
                FileOutputStream fileOutput = new FileOutputStream(outputFileName);
                OutputStreamWriter ditaFileOutput = null;
                try {
                    ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
                    if (outputFileName.equals(this.changeTable.get(outputFileName))) {
                        ditaFileOutput.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                        File workDir = new File(outputFileName).getParentFile().getAbsoluteFile();
                        if (Constants.OS_NAME.toLowerCase().indexOf("windows") == -1) {
                            ditaFileOutput.write(PI_WORKDIR_HEAD + workDir.getAbsolutePath() + PI_END);
                        } else {
                            ditaFileOutput.write("<?workdir /" + workDir.getAbsolutePath() + PI_END);
                        }
                        ditaFileOutput.write("<?workdir-uri " + workDir.toURI().toString() + PI_END);
                        if (this.conflictTable.get(outputFileName) != null) {
                            String relativePath = FileUtils.getRelativePath(this.filePath + "/" + "stub.ditamap", this.conflictTable.get(outputFileName));
                            String path2project = FileUtils.getRelativePath(relativePath);
                            if (null == path2project) {
                                path2project = "";
                            }
                            ditaFileOutput.write("<");
                            ditaFileOutput.write("?");
                            ditaFileOutput.write("path2project");
                            ditaFileOutput.write(" ");
                            ditaFileOutput.write(path2project);
                            ditaFileOutput.write("?");
                            ditaFileOutput.write(">");
                        }
                    }
                    if (needWriteDitaTag) {
                        ditaFileOutput.write("<dita xmlns:ditaarch=\"http://dita.oasis-open.org/architecture/2005/\" ditaarch:DITAArchVersion=\"1.2\">");
                    }
                    ditaFileOutput.write(((StringWriter)this.output).getBuffer().toString());
                    if (needWriteDitaTag) {
                        ditaFileOutput.write("</dita>");
                    }
                    ditaFileOutput.flush();
                }
                finally {
                    ditaFileOutput.close();
                }
                this.output = tempWriter;
                this.topicID = tempTopicID;
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    public void setup(LinkedHashMap<String, String> changeTable, Hashtable<String, String> conflictTable, Set<String> refFileSet, Element elem, boolean separate, boolean chunkByTopic, String ditaext) {
        this.changeTable = changeTable;
        this.elem = elem;
        this.separate = separate;
        this.ditaext = ditaext;
        this.conflictTable = conflictTable;
    }

    private boolean checkHREF(Attributes atts) {
        String scopeValue = atts.getValue("scope");
        String hrefValue = atts.getValue("href");
        hrefValue = StringUtils.escapeXML(hrefValue);
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (hrefValue == null || hrefValue.indexOf("://") != -1) {
            return false;
        }
        return scopeValue == null || !scopeValue.equalsIgnoreCase("external");
    }

    private String getFirstTopicId(String absolutePathToFile) {
        StringBuffer firstTopicId = new StringBuffer();
        if (absolutePathToFile == null || !FileUtils.isAbsolutePath(absolutePathToFile)) {
            return firstTopicId.toString();
        }
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            XMLReader reader = StringUtils.getXMLReader();
            reader.setContentHandler(parser);
            reader.parse(new File(absolutePathToFile).toURI().toString());
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        return firstTopicId.toString();
    }

    private void createTopicMeta(Element element, Element newChild) {
        Element topicmeta = this.elem.getOwnerDocument().createElement(Constants.MAP_TOPICMETA.localName);
        topicmeta.setAttribute("class", Constants.MAP_TOPICMETA.toString());
        newChild.appendChild(topicmeta);
        DITAAttrUtils utils = DITAAttrUtils.getInstance();
        if (element != null) {
            Text titleText;
            String text;
            NodeList list = element.getChildNodes();
            Element title = null;
            Element navtitle = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                Element childNode = (Element)node;
                if (childNode.getAttribute("class").contains(Constants.TOPIC_TITLE.matcher)) {
                    title = childNode;
                }
                if (!childNode.getAttribute("class").contains(Constants.TOPIC_TITLEALTS.matcher)) continue;
                NodeList subList = childNode.getChildNodes();
                for (int j = 0; j < subList.getLength(); ++j) {
                    Element subChildNode;
                    Node subNode = subList.item(j);
                    if (subNode.getNodeType() != 1 || !(subChildNode = (Element)subNode).getAttribute("class").contains(Constants.TOPIC_NAVTITLE.matcher)) continue;
                    navtitle = subChildNode;
                }
            }
            Element shortDesc = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem;
                String clazzValue;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (clazzValue = (elem = (Element)node).getAttribute("class")) == null || !Constants.TOPIC_SHORTDESC.matches(clazzValue)) continue;
                shortDesc = elem;
            }
            Element navtitleNode = this.elem.getOwnerDocument().createElement(Constants.TOPIC_NAVTITLE.localName);
            navtitleNode.setAttribute("class", Constants.TOPIC_NAVTITLE.toString());
            if (navtitle != null) {
                text = utils.getText(navtitle);
                titleText = this.elem.getOwnerDocument().createTextNode(text);
                navtitleNode.appendChild(titleText);
                topicmeta.appendChild(navtitleNode);
            } else {
                text = utils.getText(title);
                titleText = this.elem.getOwnerDocument().createTextNode(text);
                navtitleNode.appendChild(titleText);
                topicmeta.appendChild(navtitleNode);
            }
            ProcessingInstruction pi = this.elem.getOwnerDocument().createProcessingInstruction("ditaot", "gentext");
            topicmeta.appendChild(pi);
            Element linkTextNode = this.elem.getOwnerDocument().createElement(Constants.TOPIC_LINKTEXT.localName);
            linkTextNode.setAttribute("class", Constants.MAP_LINKTEXT.toString());
            String text2 = utils.getText(title);
            Text textNode = this.elem.getOwnerDocument().createTextNode(text2);
            linkTextNode.appendChild(textNode);
            topicmeta.appendChild(linkTextNode);
            ProcessingInstruction pii = this.elem.getOwnerDocument().createProcessingInstruction("ditaot", "genshortdesc");
            topicmeta.appendChild(pii);
            Element shortDescNode = this.elem.getOwnerDocument().createElement(Constants.TOPIC_SHORTDESC.localName);
            shortDescNode.setAttribute("class", Constants.MAP_SHORTDESC.toString());
            String shortDescText = utils.getText(shortDesc);
            Text shortDescTextNode = this.elem.getOwnerDocument().createTextNode(shortDescText);
            shortDescNode.appendChild(shortDescTextNode);
            topicmeta.appendChild(shortDescNode);
        }
    }
}

