/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class CoderefResolver
extends AbstractXMLFilter {
    private static final char[] XML_NEWLINE = new char[]{'\n'};
    private File currentFile = null;
    private int ignoreDepth = 0;

    @Override
    public void setContent(Content content) {
    }

    @Override
    public void write(String filename) throws DITAOTException {
        if (filename == null || !new File(filename).exists()) {
            return;
        }
        this.currentFile = new File(filename);
        super.write(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        block18: {
            if (this.ignoreDepth > 0) {
                ++this.ignoreDepth;
                return;
            }
            if (Constants.PR_D_CODEREF.matches(atts)) {
                ++this.ignoreDepth;
                try {
                    String hrefValue = atts.getValue("href");
                    if (hrefValue == null) break block18;
                    String codeFile = FileUtils.normalizeDirectory(this.currentFile.getParentFile().getAbsolutePath(), hrefValue);
                    if (new File(codeFile).exists()) {
                        Charset charset = this.getCharset(atts.getValue("format"));
                        BufferedReader codeReader = null;
                        try {
                            codeReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(codeFile)), charset));
                            this.copyLines(codeReader, new Range(hrefValue));
                            break block18;
                        }
                        catch (Exception e) {
                            this.logger.logError("Failed to process code reference " + codeFile, e);
                            break block18;
                        }
                        finally {
                            if (codeReader != null) {
                                try {
                                    codeReader.close();
                                }
                                catch (IOException e) {
                                    this.logger.logError(e.getMessage(), e);
                                }
                            }
                        }
                    }
                    this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTJ051E", hrefValue).setLocation(atts).toString());
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            } else {
                super.startElement(uri, localName, name, atts);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.ignoreDepth > 0) {
            --this.ignoreDepth;
            return;
        }
        super.endElement(uri, localName, name);
    }

    private void copyLines(BufferedReader codeReader, Range range) throws IOException, SAXException {
        boolean first = true;
        String line = codeReader.readLine();
        int i = 1;
        while (line != null) {
            if (i >= range.start && i <= range.end) {
                if (first) {
                    first = false;
                } else {
                    super.characters(XML_NEWLINE, 0, XML_NEWLINE.length);
                }
                char[] ch = line.toCharArray();
                super.characters(ch, 0, ch.length);
            }
            line = codeReader.readLine();
            ++i;
        }
    }

    private Charset getCharset(String value) {
        String[] tokens;
        Charset c = null;
        if (value != null && (tokens = value.trim().split("[;=]")).length >= 3 && tokens[1].trim().equals("charset")) {
            try {
                c = Charset.forName(tokens[2].trim());
            }
            catch (RuntimeException e) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ052E", tokens[2].trim()).toString());
            }
        }
        if (c == null) {
            c = Charset.defaultCharset();
        }
        return c;
    }

    private static class Range {
        final int start;
        final int end;

        Range(String uri) {
            Pattern p = Pattern.compile(".+#line-range\\((\\d+)(?:,\\s*(\\d+))?\\)");
            Matcher m = p.matcher(uri);
            if (m.matches()) {
                this.start = Integer.parseInt(m.group(1));
                this.end = m.group(2) != null ? Integer.parseInt(m.group(2)) : Integer.MAX_VALUE;
            } else {
                this.start = 0;
                this.end = Integer.MAX_VALUE;
            }
        }
    }
}

