/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ConrefPushParser
extends AbstractXMLWriter {
    private Hashtable<String, String> movetable = null;
    private String topicId = null;
    private Stack<String> idStack = null;
    private final XMLReader parser;
    private OutputStreamWriter output = null;
    private boolean needResolveEntity = true;
    private Set<String> topicSpecSet = new HashSet<String>();
    private boolean isReplaced = false;
    private int level = 0;
    private boolean hasPushafter = false;
    private int levelForPushAfter = 0;
    private Stack<Integer> levelForPushAfterStack = new Stack();
    private String contentForPushAfter = null;
    private Stack<String> contentForPushAfterStack = new Stack();
    private boolean hasConref = false;
    private String tempDir;

    public ConrefPushParser() {
        try {
            this.parser = StringUtils.getXMLReader();
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setContentHandler(this);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.parser.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.movetable = (Hashtable)content.getValue();
        if (this.movetable == null) {
            throw new IllegalArgumentException("Content value must be non-null Hashtable<String, String>");
        }
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String filename) throws DITAOTException {
        this.hasConref = false;
        this.isReplaced = false;
        this.hasPushafter = false;
        this.level = 0;
        this.levelForPushAfter = 0;
        this.idStack = new Stack();
        this.topicSpecSet = new HashSet<String>();
        this.levelForPushAfterStack = new Stack();
        this.contentForPushAfterStack = new Stack();
        try {
            File inputFile = new File(filename);
            File outputFile = new File(filename + ".cnrfpush");
            this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.parser.parse(filename);
            if (!this.movetable.isEmpty()) {
                Properties prop = new Properties();
                String key2 = null;
                for (String key2 : this.movetable.keySet()) {
                    this.logger.logWarn(MessageUtils.getInstance().getMessage("DOTJ043W", key2.substring(0, key2.indexOf("|")), filename).toString());
                }
            }
            if (this.hasConref) {
                this.updateList(filename);
            }
            this.output.close();
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception ex) {
                this.logger.logError(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(String filename) {
        BufferedWriter bufferedWriter = null;
        try {
            Job job = new Job(new File(this.tempDir));
            Set<String> conreflist = job.getSet("conreflist");
            String reletivePath = filename.substring(FileUtils.normalize(this.tempDir).length() + 1);
            for (String str : conreflist) {
                if (!str.equals(reletivePath)) continue;
                return;
            }
            HashSet<String> stringBuffer = new HashSet<String>(job.getSet("conreflist"));
            stringBuffer.add(reletivePath);
            job.setSet("conreflist", stringBuffer);
            job.write();
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(this.tempDir, "conref.list"))));
                for (String str : conreflist) {
                    bufferedWriter.append(str).append("\n");
                }
                bufferedWriter.append(reletivePath);
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isReplaced && this.needResolveEntity) {
            try {
                this.output.write(StringUtils.escapeXML(ch, start, length));
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isReplaced) {
            --this.level;
            if (this.level == 0) {
                this.isReplaced = false;
            }
        } else {
            try {
                this.output.write("<");
                this.output.write("/");
                this.output.write(name);
                this.output.write(">");
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
        if (this.hasPushafter) {
            --this.levelForPushAfter;
            if (this.levelForPushAfter == 0) {
                try {
                    if (this.contentForPushAfter != null) {
                        this.output.write(this.contentForPushAfter);
                    }
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
                if (!this.levelForPushAfterStack.isEmpty() && !this.contentForPushAfterStack.isEmpty()) {
                    this.levelForPushAfter = this.levelForPushAfterStack.pop();
                    this.contentForPushAfter = this.contentForPushAfterStack.pop();
                } else {
                    this.hasPushafter = false;
                    this.contentForPushAfter = null;
                }
            }
        }
        if (!this.idStack.isEmpty() && this.topicSpecSet.contains(name)) {
            this.topicId = this.idStack.pop();
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.isReplaced) {
            try {
                String pi = data != null ? target + " " + data : target;
                this.output.write("<?" + pi + "?" + ">");
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    private boolean isPushedTypeMatch(String targetClassAttribute, String string) {
        String clazz;
        block3: {
            clazz = "";
            InputSource inputSource = null;
            Document document = null;
            string = "<stub>" + string + "</stub>";
            inputSource = new InputSource(new StringReader(string));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Element element = null;
            NodeList nodeList = null;
            new StringBuffer();
            try {
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                document = documentBuilder.parse(inputSource);
                element = document.getDocumentElement();
                if (!element.hasChildNodes()) break block3;
                nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element elem = (Element)node;
                    clazz = elem.getAttribute("class");
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return clazz.equalsIgnoreCase(targetClassAttribute) || clazz.contains(targetClassAttribute);
    }

    private String replaceElementName(String targetClassAttribute, String string) {
        InputSource inputSource = null;
        Document document = null;
        string = "<stub>" + string + "</stub>";
        inputSource = new InputSource(new StringReader(string));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element element = null;
        NodeList nodeList = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            element = document.getDocumentElement();
            if (element.hasChildNodes()) {
                nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element elem = (Element)node;
                    NodeList nList = null;
                    String clazz = elem.getAttribute("class");
                    String type = targetClassAttribute.substring(1, targetClassAttribute.indexOf("/")).trim();
                    if (!clazz.equalsIgnoreCase(targetClassAttribute) && clazz.contains(targetClassAttribute)) {
                        String targetElementName = targetClassAttribute.substring(targetClassAttribute.indexOf("/") + 1).trim();
                        stringBuffer.append("<").append(targetElementName);
                        NamedNodeMap namedNodeMap = elem.getAttributes();
                        for (int t = 0; t < namedNodeMap.getLength(); ++t) {
                            if (namedNodeMap.item(t).getNodeName().equals("conref") && namedNodeMap.item(t).getNodeValue().length() != 0) {
                                this.hasConref = true;
                            }
                            stringBuffer.append(" ").append(namedNodeMap.item(t).getNodeName()).append("=").append("\"" + StringUtils.escapeXML(namedNodeMap.item(t).getNodeValue()) + "\"");
                        }
                        stringBuffer.append(">");
                        nList = elem.getChildNodes();
                        for (int j = 0; j < nList.getLength(); ++j) {
                            Node subNode = nList.item(j);
                            if (subNode.getNodeType() == 1) {
                                stringBuffer.append(this.replaceSubElementName(type, (Element)subNode));
                            }
                            if (subNode.getNodeType() == 7) {
                                stringBuffer.append("<?").append(subNode.getNodeName()).append("?>");
                            }
                            if (subNode.getNodeType() != 3) continue;
                            stringBuffer.append(StringUtils.escapeXML(subNode.getNodeValue()));
                        }
                        stringBuffer.append("</").append(targetElementName).append(">");
                        continue;
                    }
                    stringBuffer.append(this.replaceSubElementName(" ", elem));
                }
                return stringBuffer.toString();
            }
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    private String replaceSubElementName(String type, Element elem) {
        StringBuffer stringBuffer = new StringBuffer();
        String classValue = elem.getAttribute("class");
        String generalizedElemName = elem.getNodeName();
        if (classValue != null && classValue.contains(type) && !type.equals(" ")) {
            generalizedElemName = classValue.substring(classValue.indexOf("/") + 1, classValue.indexOf(" ", classValue.indexOf("/"))).trim();
        }
        stringBuffer.append("<").append(generalizedElemName);
        NamedNodeMap namedNodeMap = elem.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (namedNodeMap.item(i).getNodeName().equals("conref") && namedNodeMap.item(i).getNodeValue().length() != 0) {
                this.hasConref = true;
            }
            stringBuffer.append(" ").append(namedNodeMap.item(i).getNodeName()).append("=").append("\"" + StringUtils.escapeXML(namedNodeMap.item(i).getNodeValue()) + "\"");
        }
        stringBuffer.append(">");
        NodeList nodeList = elem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                stringBuffer.append(this.replaceSubElementName(type, (Element)node));
            }
            if (node.getNodeType() == 7) {
                stringBuffer.append("<?").append(node.getNodeName()).append("?>");
            }
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(StringUtils.escapeXML(node.getNodeValue()));
        }
        stringBuffer.append("</").append(generalizedElemName).append(">");
        return stringBuffer.toString();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.hasPushafter) {
            ++this.levelForPushAfter;
        }
        if (this.isReplaced) {
            ++this.level;
        } else {
            try {
                String classValue = atts.getValue("class");
                if (classValue != null && Constants.TOPIC_TOPIC.matches(classValue)) {
                    String idValue;
                    if (!this.topicSpecSet.contains(name)) {
                        this.topicSpecSet.add(name);
                    }
                    if ((idValue = atts.getValue("id")) != null) {
                        if (this.topicId != null) {
                            this.idStack.push(this.topicId);
                        }
                        this.topicId = idValue;
                    }
                } else if (atts.getValue("id") != null) {
                    String idPath = "#" + this.topicId + "/" + atts.getValue("id");
                    String defaultidPath = "#" + atts.getValue("id");
                    String containkey = null;
                    if (classValue != null && (Constants.MAP_TOPICREF.matches(classValue) || Constants.MAP_MAP.matches(classValue))) {
                        String mapId = atts.getValue("id");
                        idPath = "#" + mapId;
                        this.idStack.push(mapId);
                    }
                    atts.getValue("class");
                    boolean containpushbefore = false;
                    if (this.movetable.containsKey(idPath + "|" + "pushbefore")) {
                        containkey = idPath + "|" + "pushbefore";
                        if (this.isPushedTypeMatch(classValue, this.movetable.get(containkey))) {
                            containpushbefore = true;
                        }
                    } else if (this.movetable.containsKey(defaultidPath + "|" + "pushbefore") && this.isPushedTypeMatch(classValue, this.movetable.get(containkey = defaultidPath + "|" + "pushbefore"))) {
                        containpushbefore = true;
                    }
                    if (containpushbefore) {
                        this.output.write(this.replaceElementName(classValue, this.movetable.remove(containkey)));
                    }
                    boolean containpushplace = false;
                    if (this.movetable.containsKey(idPath + "|" + "pushreplace")) {
                        containkey = idPath + "|" + "pushreplace";
                        if (this.isPushedTypeMatch(classValue, this.movetable.get(containkey))) {
                            containpushplace = true;
                        }
                    } else if (this.movetable.containsKey(defaultidPath + "|" + "pushreplace") && this.isPushedTypeMatch(classValue, this.movetable.get(containkey = defaultidPath + "|" + "pushreplace"))) {
                        containpushplace = true;
                    }
                    if (containpushplace) {
                        this.output.write(this.replaceElementName(classValue, this.movetable.remove(containkey)));
                        this.isReplaced = true;
                        this.level = 0;
                        ++this.level;
                    }
                    boolean containpushafter = false;
                    if (this.movetable.containsKey(idPath + "|" + "pushafter")) {
                        containkey = idPath + "|" + "pushafter";
                        if (this.isPushedTypeMatch(classValue, this.movetable.get(containkey))) {
                            containpushafter = true;
                        }
                    } else if (this.movetable.containsKey(defaultidPath + "|" + "pushafter") && this.isPushedTypeMatch(classValue, this.movetable.get(containkey = defaultidPath + "|" + "pushafter"))) {
                        containpushafter = true;
                    }
                    if (containpushafter) {
                        if (this.hasPushafter && this.levelForPushAfter > 0) {
                            this.levelForPushAfterStack.push(this.levelForPushAfter);
                            this.contentForPushAfterStack.push(this.contentForPushAfter);
                        } else {
                            this.hasPushafter = true;
                        }
                        this.levelForPushAfter = 0;
                        ++this.levelForPushAfter;
                        this.contentForPushAfter = this.replaceElementName(classValue, this.movetable.remove(containkey));
                    }
                }
                if (!this.isReplaced) {
                    this.output.write("<");
                    this.output.write(name);
                    for (int index = 0; index < atts.getLength(); ++index) {
                        this.output.write(" ");
                        this.output.write(atts.getQName(index));
                        this.output.write("=\"");
                        String value = atts.getValue(index);
                        value = StringUtils.escapeXML(value);
                        this.output.write(value);
                        this.output.write("\"");
                    }
                    this.output.write(">");
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
            this.output.close();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.isReplaced) {
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }
}

