/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DitaIndexWriter
extends AbstractXMLWriter {
    private String firstMatchTopic = null;
    private boolean hasMetadataTillNow = false;
    private boolean hasPrologTillNow = false;
    private String indexEntries = null;
    private String lastMatchTopic = null;
    private List<String> matchList = null;
    private boolean needResolveEntity = false;
    private OutputStreamWriter output = null;
    private final XMLReader reader;
    private boolean startTopic = false;
    private final List<String> topicIdList;
    private boolean insideCDATA = false;
    private boolean hasWritten = false;
    private final ArrayList<String> topicSpecList = new ArrayList();
    private int topicLevel = -1;

    public DitaIndexWriter() {
        this.topicIdList = new ArrayList<String>(16);
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    private boolean checkMatch() {
        if (this.matchList == null) {
            return true;
        }
        int matchSize = this.matchList.size();
        int ancestorSize = this.topicIdList.size();
        List<String> tail = this.topicIdList.subList(ancestorSize - matchSize, ancestorSize);
        return this.matchList.equals(tail);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startTopic) {
            this.topicIdList.remove(this.topicIdList.size() - 1);
        }
        try {
            if (this.topicSpecList.contains(localName)) {
                --this.topicLevel;
            }
            if (!this.hasMetadataTillNow && Constants.TOPIC_PROLOG.localName.equals(qName) && this.startTopic && !this.hasWritten) {
                this.output.write("<metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata>");
                this.hasMetadataTillNow = true;
                this.hasWritten = true;
            }
            this.output.write("</" + qName + ">");
            if (!this.hasPrologTillNow && this.startTopic && !this.hasWritten && !this.topicSpecList.contains(localName)) {
                this.output.write(Constants.LINE_SEPARATOR);
                this.output.write("<prolog class=\"- topic/prolog \"><metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata></prolog>");
                this.hasPrologTillNow = true;
                this.hasWritten = true;
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    private boolean hasMetadata(String qName) {
        return !this.hasPrologTillNow || this.hasMetadataTillNow || !Constants.TOPIC_RESOURCEID.localName.equals(qName);
    }

    private boolean hasProlog(Attributes atts) {
        if (atts.getValue("class") != null && !this.hasPrologTillNow) {
            if (atts.getValue("class").indexOf(Constants.TOPIC_BODY.matcher) != -1) {
                return false;
            }
            if (atts.getValue("class").indexOf(Constants.TOPIC_RELATED_LINKS.matcher) != -1) {
                return false;
            }
            if (atts.getValue("class").indexOf(Constants.TOPIC_TOPIC.matcher) != -1) {
                if (this.topicLevel > 0) {
                    ++this.topicLevel;
                } else if (this.topicLevel == -1) {
                    this.topicLevel = 1;
                } else {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.indexEntries = (String)content.getValue();
        if (this.indexEntries == null) {
            throw new IllegalArgumentException("Content value must be non-null String");
        }
    }

    private void setMatch(String match) {
        int index = 0;
        this.matchList = new ArrayList<String>(16);
        String string = this.firstMatchTopic = match.indexOf("/") != -1 ? match.substring(0, match.indexOf(47)) : match;
        while (index != -1) {
            int end = match.indexOf("/", index);
            if (end == -1) {
                this.matchList.add(match.substring(index));
                this.lastMatchTopic = match.substring(index);
                index = end;
                continue;
            }
            this.matchList.add(match.substring(index, end));
            index = end + 1;
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.output.write(StringUtils.getEntity(name));
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.insideCDATA = true;
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int attsLen = atts.getLength();
        try {
            if (this.topicLevel != -1 && !this.hasProlog(atts) && this.startTopic && !this.hasWritten) {
                this.output.write(Constants.LINE_SEPARATOR);
                this.output.write("<prolog class=\"- topic/prolog \"><metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata></prolog>");
                this.hasPrologTillNow = true;
                this.hasWritten = true;
            }
            if (!this.startTopic && !"dita".equalsIgnoreCase(qName)) {
                if (atts.getValue("id") != null) {
                    this.topicIdList.add(atts.getValue("id"));
                } else {
                    this.topicIdList.add("null");
                }
                if (this.topicIdList.size() >= this.matchList.size()) {
                    this.startTopic = this.checkMatch();
                }
            }
            if (!this.hasMetadata(qName) && this.startTopic && !this.hasWritten) {
                this.output.write("<metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata>");
                this.hasMetadataTillNow = true;
                this.hasWritten = true;
            }
            this.output.write("<" + qName);
            for (int i = 0; i < attsLen; ++i) {
                String attQName = atts.getQName(i);
                String attValue = atts.getValue(i);
                if (attValue.indexOf(38) > 0) {
                    attValue = StringUtils.replaceAll(attValue, "&", "&amp;");
                }
                this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
            }
            this.output.write(">");
            if (atts.getValue("class") != null) {
                if (atts.getValue("class").indexOf(Constants.TOPIC_METADATA.matcher) != -1 && this.startTopic && !this.hasWritten) {
                    this.hasMetadataTillNow = true;
                    this.output.write(this.indexEntries);
                    this.hasWritten = true;
                }
                if (atts.getValue("class").indexOf(Constants.TOPIC_PROLOG.matcher) != -1) {
                    this.hasPrologTillNow = true;
                }
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String outputFilename) {
        String filename = outputFilename;
        String file = null;
        String topic = null;
        File inputFile = null;
        File outputFile = null;
        try {
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            if (filename.lastIndexOf("#") != -1) {
                file = filename.substring(0, filename.lastIndexOf("#"));
                topic = filename.substring(filename.lastIndexOf("#") + 1);
                this.setMatch(topic);
                this.startTopic = false;
            } else {
                file = filename;
                this.matchList = null;
                this.startTopic = true;
            }
            this.needResolveEntity = true;
            this.hasPrologTillNow = false;
            this.hasMetadataTillNow = false;
            this.hasWritten = false;
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.topicIdList.clear();
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file, this.logger));
            this.reader.parse(file);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
        try {
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }
}

