/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DitaLinksWriter
extends AbstractXMLWriter {
    private String curMatchTopic = null;
    private boolean firstTopic = true;
    private Map<String, String> indexEntries = null;
    private Set<String> topicSet = null;
    private boolean needResolveEntity = false;
    private OutputStreamWriter output = null;
    private final XMLReader reader;
    private Stack<String> topicIdStack = null;
    private boolean insideCDATA = false;
    private final ArrayList<String> topicSpecList = new ArrayList();

    public DitaLinksWriter() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.topicSpecList.contains(localName)) {
            if (!this.topicIdStack.empty()) {
                this.topicIdStack.pop();
            }
            if (this.firstTopic) {
                this.firstTopic = false;
            }
        }
        try {
            if (this.curMatchTopic != null && this.topicSpecList.contains(localName)) {
                this.output.write("<related-links class=\"- topic/related-links \">");
                this.output.write(this.indexEntries.get(this.curMatchTopic));
                this.output.write("</related-links>");
                this.output.write(Constants.LINE_SEPARATOR);
                this.curMatchTopic = null;
            }
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.indexEntries = (HashMap)content.getValue();
        if (this.indexEntries == null) {
            throw new IllegalArgumentException("Content value must be non-null HashMap<String, String>");
        }
        this.topicSet = this.indexEntries.keySet();
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.output.write(StringUtils.getEntity(name));
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.insideCDATA = true;
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.topicIdStack.clear();
        this.firstTopic = true;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block15: {
            int attsLen = atts.getLength();
            if (atts.getValue("class") != null && atts.getValue("class").contains(Constants.TOPIC_TOPIC.matcher)) {
                String t;
                block14: {
                    if (!this.topicSpecList.contains(localName)) {
                        this.topicSpecList.add(localName);
                    }
                    if (!"dita".equalsIgnoreCase(qName) && atts.getValue("id") != null) {
                        this.topicIdStack.push(atts.getValue("id"));
                    }
                    if (this.curMatchTopic != null && !this.firstTopic) {
                        try {
                            this.output.write("<related-links class=\"- topic/related-links \">");
                            this.output.write(this.indexEntries.get(this.curMatchTopic));
                            this.output.write("</related-links>");
                            this.output.write(Constants.LINE_SEPARATOR);
                            this.curMatchTopic = null;
                        }
                        catch (Exception e) {
                            if (atts.getValue("class") == null) break block14;
                            this.logger.logError(e.getMessage(), e);
                        }
                    }
                }
                if (this.topicSet.contains(t = StringUtils.assembleString(this.topicIdStack, "/"))) {
                    this.curMatchTopic = t;
                } else if (this.topicSet.contains(this.topicIdStack.peek())) {
                    this.curMatchTopic = this.topicIdStack.peek();
                }
                if (this.firstTopic) {
                    this.firstTopic = false;
                }
            }
            try {
                this.output.write("<" + qName);
                for (int i = 0; i < attsLen; ++i) {
                    String attQName = atts.getQName(i);
                    String attValue = atts.getValue(i);
                    attValue = StringUtils.escapeXML(attValue);
                    this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
                }
                this.output.write(">");
                if (atts.getValue("class") != null && atts.getValue("class").indexOf(Constants.TOPIC_RELATED_LINKS.matcher) != -1 && this.curMatchTopic != null) {
                    this.output.write(this.indexEntries.get(this.curMatchTopic));
                    this.curMatchTopic = null;
                }
            }
            catch (Exception e) {
                if (atts.getValue("class") == null) break block15;
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String filename) {
        String file = null;
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        try {
            file = filename;
            String string = this.curMatchTopic = this.topicSet.contains("#") ? "#" : null;
            if (file == null || !new File(file).exists()) {
                return;
            }
            this.needResolveEntity = true;
            this.topicIdStack = new Stack();
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file, this.logger));
            this.reader.parse(inputFile.toURI().toString());
            this.output.close();
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }
}

