/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.reader.MapMetaReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DitaMetaWriter
extends AbstractXMLWriter {
    private String firstMatchTopic;
    private String lastMatchTopic;
    private Hashtable<String, Node> metaTable = null;
    private List<String> matchList = null;
    private boolean needResolveEntity = false;
    private Writer output = null;
    private OutputStreamWriter ditaFileOutput;
    private StringWriter strOutput;
    private final XMLReader reader;
    private boolean startTopic = false;
    private boolean startDOM;
    private boolean hasWritten;
    private final List<String> topicIdList = new ArrayList<String>(16);
    private boolean insideCDATA = false;
    private final ArrayList<String> topicSpecList = new ArrayList(16);
    private static final Map<String, List<String>> moveTable;
    private static final Map<String, Integer> compareTable;

    public DitaMetaWriter() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    private boolean checkMatch() {
        if (this.matchList == null) {
            return true;
        }
        int matchSize = this.matchList.size();
        int ancestorSize = this.topicIdList.size();
        List<String> tail = this.topicIdList.subList(ancestorSize - matchSize, ancestorSize);
        return this.matchList.equals(tail);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startTopic) {
            this.topicIdList.remove(this.topicIdList.size() - 1);
        }
        try {
            if (this.startTopic && this.topicSpecList.contains(qName)) {
                if (this.startDOM) {
                    this.startDOM = false;
                    this.output.write("</topic>");
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                } else if (!this.hasWritten) {
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                }
            }
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void processDOM() {
        try {
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.strOutput.getBuffer().length() > 0) {
                builder.setErrorHandler(new DITAOTXMLErrorHandler(this.strOutput.toString(), this.logger));
                doc = builder.parse(new InputSource(new StringReader(this.strOutput.toString())));
            } else {
                doc = builder.newDocument();
                doc.appendChild(doc.createElement("topic"));
            }
            Element root = doc.getDocumentElement();
            for (Map.Entry<String, Node> entry : this.metaTable.entrySet()) {
                this.moveMeta(entry, root);
            }
            this.outputMeta(root);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        this.hasWritten = true;
    }

    private void outputMeta(Node root) throws IOException {
        NodeList children = root.getChildNodes();
        Node child = null;
        block5: for (int i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child);
                    continue block5;
                }
                case 7: {
                    this.output((ProcessingInstruction)child);
                    continue block5;
                }
                case 1: {
                    this.output((Element)child);
                }
            }
        }
    }

    private void output(ProcessingInstruction instruction) throws IOException {
        this.output.write("<?" + instruction.getTarget() + " " + instruction.getData() + "?>");
    }

    private void output(Text text) throws IOException {
        this.output.write(StringUtils.escapeXML(text.getData()));
    }

    private void output(Element elem) throws IOException {
        this.output.write("<" + elem.getNodeName());
        NamedNodeMap attrMap = elem.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            String nodeName = attrMap.item(i).getNodeName();
            String nodeValue = StringUtils.escapeXML(attrMap.item(i).getNodeValue());
            this.output.write(" " + nodeName + "=\"" + nodeValue + "\"");
        }
        this.output.write(">");
        NodeList children = elem.getChildNodes();
        block6: for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child);
                    continue block6;
                }
                case 7: {
                    this.output((ProcessingInstruction)child);
                    continue block6;
                }
                case 1: {
                    this.output((Element)child);
                }
            }
        }
        this.output.write("</" + elem.getNodeName() + ">");
    }

    private void moveMeta(Map.Entry<String, Node> entry, Node root) {
        List<String> metaPath = moveTable.get(entry.getKey());
        if (metaPath == null) {
            return;
        }
        Iterator<String> token = metaPath.iterator();
        Node parent = null;
        Node child = root;
        Node current = null;
        boolean createChild = false;
        while (token.hasNext()) {
            String next = token.next();
            parent = child;
            Integer nextIndex = compareTable.get(next);
            Integer currentIndex = null;
            NodeList childElements = parent.getChildNodes();
            for (int i = 0; i < childElements.getLength(); ++i) {
                String name = null;
                current = childElements.item(i);
                if (current.getNodeType() == 1) {
                    name = current.getNodeName();
                }
                if (name != null && current.getNodeName().equals(next)) {
                    child = current;
                    break;
                }
                if (name == null) continue;
                currentIndex = compareTable.get(name);
                if (currentIndex == null) {
                    String classValue = ((Element)current).getAttribute("class");
                    String generalizedName = classValue.substring(classValue.indexOf("/") + 1);
                    generalizedName = generalizedName.substring(0, generalizedName.indexOf(" "));
                    currentIndex = compareTable.get(generalizedName);
                }
                if (currentIndex == null) {
                    this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ038E", name).toString());
                    break;
                }
                if (currentIndex.compareTo(nextIndex) > 0) break;
            }
            if (child != parent) continue;
            child = parent.getOwnerDocument().createElement(next);
            ((Element)child).setAttribute("class", "- topic/" + next + " ");
            if (current == null || currentIndex == null || nextIndex.compareTo(currentIndex) >= 0) {
                parent.appendChild(child);
                current = null;
            } else {
                parent.insertBefore(child, current);
                current = null;
            }
            createChild = true;
        }
        NodeList list = entry.getValue().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (i == 0 && createChild || MapMetaReader.uniqueSet.contains(entry.getKey())) {
                item = parent.getOwnerDocument().importNode(item, true);
                parent.replaceChild(item, child);
                child = item;
                continue;
            }
            item = parent.getOwnerDocument().importNode(item, true);
            ((Element)parent).insertBefore(item, child);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.metaTable = (Hashtable)content.getValue();
        if (this.metaTable == null) {
            throw new IllegalArgumentException("Content value must be non-null Hashtable<String, Node>");
        }
    }

    private void setMatch(String match) {
        int index = 0;
        this.matchList = new ArrayList<String>(16);
        String string = this.firstMatchTopic = match.indexOf("/") != -1 ? match.substring(0, match.indexOf(47)) : match;
        while (index != -1) {
            int end = match.indexOf("/", index);
            if (end == -1) {
                this.matchList.add(match.substring(index));
                this.lastMatchTopic = match.substring(index);
                index = end;
                continue;
            }
            this.matchList.add(match.substring(index, end));
            index = end + 1;
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.output.write(StringUtils.getEntity(name));
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.insideCDATA = true;
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classAttrValue = atts.getValue("class");
        try {
            if (classAttrValue != null && Constants.TOPIC_TOPIC.matches(classAttrValue) && !this.topicSpecList.contains(qName)) {
                this.topicSpecList.add(qName);
            }
            if (this.startTopic && !this.startDOM && classAttrValue != null && !this.hasWritten && (Constants.TOPIC_PROLOG.matches(classAttrValue) || Constants.TOPIC_ABSTRACT.matches(classAttrValue) || Constants.TOPIC_SHORTDESC.matches(classAttrValue) || Constants.TOPIC_TITLEALTS.matches(classAttrValue))) {
                this.startDOM = true;
                this.output = this.strOutput;
                this.output.write("<topic>");
            }
            if (this.startTopic && classAttrValue != null && !this.hasWritten && (Constants.TOPIC_TOPIC.matches(classAttrValue) || Constants.TOPIC_RELATED_LINKS.matches(classAttrValue) || Constants.TOPIC_BODY.matches(classAttrValue))) {
                if (this.startDOM) {
                    this.startDOM = false;
                    this.output.write("</topic>");
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                } else {
                    this.processDOM();
                }
            }
            if (!this.startTopic && !"dita".equalsIgnoreCase(qName)) {
                if (atts.getValue("id") != null) {
                    this.topicIdList.add(atts.getValue("id"));
                } else {
                    this.topicIdList.add("null");
                }
                if (this.matchList == null) {
                    this.startTopic = true;
                } else if (this.topicIdList.size() >= this.matchList.size()) {
                    this.startTopic = this.checkMatch();
                }
            }
            this.outputElement(qName, atts);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void outputElement(String qName, Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        this.output.write("<" + qName);
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            attValue = StringUtils.escapeXML(attValue);
            this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
        }
        this.output.write(">");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String outputFilename) {
        String filename = outputFilename;
        String file = null;
        String topic = null;
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        try {
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            if (filename.lastIndexOf("#") != -1) {
                file = filename.substring(0, filename.lastIndexOf("#"));
                topic = filename.substring(filename.lastIndexOf("#") + 1);
                this.setMatch(topic);
                this.startTopic = false;
            } else {
                file = filename;
                this.matchList = null;
                this.startTopic = false;
            }
            this.needResolveEntity = true;
            this.hasWritten = false;
            this.startDOM = false;
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.strOutput = new StringWriter();
            this.output = this.ditaFileOutput;
            this.topicIdList.clear();
            this.reader.parse(inputFile.toURI().toString());
            this.output.close();
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    static {
        HashMap<String, List<String>> mt = new HashMap<String, List<String>>(32);
        mt.put(Constants.MAP_SEARCHTITLE.matcher, Arrays.asList(Constants.TOPIC_TITLEALTS.localName, Constants.TOPIC_SEARCHTITLE.localName));
        mt.put(Constants.TOPIC_AUDIENCE.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_METADATA.localName, Constants.TOPIC_AUDIENCE.localName));
        mt.put(Constants.TOPIC_AUTHOR.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_AUTHOR.localName));
        mt.put(Constants.TOPIC_CATEGORY.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_METADATA.localName, Constants.TOPIC_CATEGORY.localName));
        mt.put(Constants.TOPIC_COPYRIGHT.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_COPYRIGHT.localName));
        mt.put(Constants.TOPIC_CRITDATES.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_CRITDATES.localName));
        mt.put(Constants.TOPIC_DATA.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_DATA.localName));
        mt.put(Constants.TOPIC_DATA_ABOUT.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_DATA_ABOUT.localName));
        mt.put(Constants.TOPIC_FOREIGN.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_FOREIGN.localName));
        mt.put(Constants.TOPIC_KEYWORDS.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_METADATA.localName, Constants.TOPIC_KEYWORDS.localName));
        mt.put(Constants.TOPIC_OTHERMETA.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_METADATA.localName, Constants.TOPIC_OTHERMETA.localName));
        mt.put(Constants.TOPIC_PERMISSIONS.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_PERMISSIONS.localName));
        mt.put(Constants.TOPIC_PRODINFO.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_METADATA.localName, Constants.TOPIC_PRODINFO.localName));
        mt.put(Constants.TOPIC_PUBLISHER.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_PUBLISHER.localName));
        mt.put(Constants.TOPIC_RESOURCEID.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_RESOURCEID.localName));
        mt.put(Constants.MAP_MAP.matcher, Arrays.asList(Constants.TOPIC_TITLEALTS.localName, Constants.TOPIC_SEARCHTITLE.localName));
        mt.put(Constants.TOPIC_SOURCE.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_SOURCE.localName));
        mt.put(Constants.TOPIC_UNKNOWN.matcher, Arrays.asList(Constants.TOPIC_PROLOG.localName, Constants.TOPIC_UNKNOWN.localName));
        moveTable = Collections.unmodifiableMap(mt);
        HashMap<String, Integer> ct = new HashMap<String, Integer>(32);
        ct.put(Constants.TOPIC_TITLEALTS.localName, 1);
        ct.put(Constants.TOPIC_NAVTITLE.localName, 2);
        ct.put(Constants.TOPIC_SEARCHTITLE.localName, 3);
        ct.put(Constants.TOPIC_ABSTRACT.localName, 4);
        ct.put(Constants.TOPIC_SHORTDESC.localName, 5);
        ct.put(Constants.TOPIC_PROLOG.localName, 6);
        ct.put(Constants.TOPIC_AUTHOR.localName, 7);
        ct.put(Constants.TOPIC_SOURCE.localName, 8);
        ct.put(Constants.TOPIC_PUBLISHER.localName, 9);
        ct.put(Constants.TOPIC_COPYRIGHT.localName, 10);
        ct.put(Constants.TOPIC_CRITDATES.localName, 11);
        ct.put(Constants.TOPIC_PERMISSIONS.localName, 12);
        ct.put(Constants.TOPIC_METADATA.localName, 13);
        ct.put(Constants.TOPIC_AUDIENCE.localName, 14);
        ct.put(Constants.TOPIC_CATEGORY.localName, 15);
        ct.put(Constants.TOPIC_KEYWORDS.localName, 16);
        ct.put(Constants.TOPIC_PRODINFO.localName, 17);
        ct.put(Constants.TOPIC_OTHERMETA.localName, 18);
        ct.put(Constants.TOPIC_RESOURCEID.localName, 19);
        ct.put(Constants.TOPIC_DATA.localName, 20);
        ct.put(Constants.TOPIC_DATA_ABOUT.localName, 21);
        ct.put(Constants.TOPIC_FOREIGN.localName, 22);
        ct.put(Constants.TOPIC_UNKNOWN.localName, 23);
        compareTable = Collections.unmodifiableMap(ct);
    }
}

