/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.reader.GrammarPoolManager;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.ValidationFilter;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class DitaWriter
extends AbstractXMLFilter {
    private static final String ATTRIBUTE_NAME_COLNAME = "colname";
    private static final String ATTRIBUTE_NAME_COLNUM = "colnum";
    private static final String COLUMN_NAME_COL = "col";
    public static final String PI_PATH2PROJ_TARGET = "path2project";
    public static final String PI_PATH2PROJ_TARGET_URI = "path2project-uri";
    public static final String PI_WORKDIR_TARGET = "workdir";
    public static final String PI_WORKDIR_TARGET_URI = "workdir-uri";
    private static final String NOT_LOCAL_URL = "://";
    private final boolean genDebugInfo = Boolean.parseBoolean(Configuration.configuration.get("generate-debug-attributes"));
    private boolean setSystemid = true;
    private File absolutePath = null;
    private List<String> colSpec = null;
    private int columnNumber = 1;
    private int columnNumberEnd = 0;
    private final Stack<List<String>> colSpecStack;
    private final Stack<String> classStack;
    private final Stack<Integer> rowNumStack;
    private final Stack<Integer> columnNumberStack;
    private final Stack<Integer> columnNumberEndStack;
    private final Stack<Map<String, Integer>> rowsMapStack;
    private final Stack<Map<String, Integer>> colSpanMapStack;
    private int rowNumber = 0;
    private int totalColumns = 0;
    private Map<String, Integer> rowsMap = new HashMap<String, Integer>();
    private Map<String, Integer> colSpanMap = new HashMap<String, Integer>();
    private String transtype;
    private Map<String, Integer> counterMap = null;
    private int foreignLevel = 0;
    private String path2Project = null;
    private File tempDir = null;
    private File traceFilename = null;
    private Map<String, KeyDef> keys;
    private String inputFile = null;
    private Map<String, Map<String, Set<String>>> validateMap = null;
    private Map<String, Map<String, String>> defaultValueMap = null;
    private FilterUtils filterUtils;
    private DelayConrefUtils delayConrefUtils;
    private OutputUtils outputUtils;
    private XMLReader reader = null;
    private String extName;
    private Locator locator;

    private boolean checkDITAHREF(Attributes atts) {
        String classValue = atts.getValue("class");
        String scopeValue = atts.getValue("scope");
        String formatValue = atts.getValue("format");
        if (classValue == null || !Constants.TOPIC_XREF.matches(classValue) && !Constants.TOPIC_LINK.matches(classValue) && !Constants.MAP_TOPICREF.matches(classValue) && !Constants.TOPIC_LONGDESCREF.matches(classValue)) {
            return false;
        }
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (formatValue == null) {
            formatValue = "dita";
        }
        return scopeValue.equalsIgnoreCase("local") && formatValue.equalsIgnoreCase("dita");
    }

    private String replaceCONREF(Attributes atts) {
        String attValue = atts.getValue("conref");
        int sharp_index = attValue.lastIndexOf("#");
        int dot_index = attValue.lastIndexOf(".");
        if (sharp_index != -1 && dot_index < sharp_index) {
            File target;
            String path = attValue.substring(0, sharp_index);
            String topic = attValue.substring(sharp_index);
            if (path.length() != 0 && (target = new File(path)).isAbsolute()) {
                String relativePath = FileUtils.getRelativePath(this.outputUtils.getInputMapPathName().getAbsolutePath(), path);
                attValue = relativePath + topic;
            }
        } else {
            File target = new File(attValue);
            if (target.isAbsolute()) {
                attValue = FileUtils.getRelativePath(this.outputUtils.getInputMapPathName().getAbsolutePath(), attValue);
            }
        }
        if (attValue != null && Configuration.processingMode == Configuration.Mode.LAX) {
            attValue = FileUtils.separatorsToUnix(attValue);
        }
        if (this.extName != null && attValue.indexOf(".ditamap") == -1) {
            return FileUtils.replaceExtension(attValue, this.extName);
        }
        return attValue;
    }

    private static boolean notLocalURL(String valueOfURL) {
        return valueOfURL.indexOf(NOT_LOCAL_URL) != -1;
    }

    private static boolean warnOfNoneTopicFormat(Attributes attrs, String valueOfHref) {
        String hrefValue = valueOfHref;
        if (DitaWriter.notLocalURL(hrefValue)) {
            return true;
        }
        String classValue = attrs.getValue("class");
        if (classValue != null && Constants.PR_D_CODEREF.matches(classValue)) {
            return true;
        }
        String formatValue = attrs.getValue("format");
        String extOfHref = FileUtils.getExtension(valueOfHref);
        if (formatValue == null && extOfHref != null && !extOfHref.equalsIgnoreCase("DITA") && !extOfHref.equalsIgnoreCase("XML")) {
            DITAOTJavaLogger logger = new DITAOTJavaLogger();
            logger.logError(MessageUtils.getInstance().getMessage("DOTJ028E", hrefValue).toString());
            return true;
        }
        return false;
    }

    private String replaceHREF(String attName, Attributes atts) {
        if (attName == null) {
            return null;
        }
        String attValue = atts.getValue(attName);
        if (attValue != null) {
            int dot_index = attValue.lastIndexOf(".");
            int sharp_index = attValue.lastIndexOf("#");
            if (sharp_index != -1 && dot_index < sharp_index) {
                String path = attValue.substring(0, sharp_index);
                String topic = attValue.substring(sharp_index);
                if (path.length() != 0) {
                    File target;
                    if (path.startsWith("file:/") && path.indexOf("file://") == -1) {
                        path = path.substring("file:/".length());
                        if ("/".equals(File.separator)) {
                            path = "/" + path;
                        }
                    }
                    if ((target = new File(path)).isAbsolute()) {
                        String relativePath = FileUtils.getRelativePath(this.outputUtils.getInputMapPathName().getAbsolutePath(), path);
                        attValue = relativePath + topic;
                    }
                }
            } else {
                File target;
                if (attValue.startsWith("file:/") && attValue.indexOf("file://") == -1) {
                    attValue = attValue.substring("file:/".length());
                    if ("/".equals(File.separator)) {
                        attValue = "/" + attValue;
                    }
                }
                if ((target = new File(attValue)).isAbsolute()) {
                    attValue = FileUtils.getRelativePath(this.outputUtils.getInputMapPathName().getAbsolutePath(), attValue);
                }
            }
        } else {
            return null;
        }
        if (this.checkDITAHREF(atts) && !DitaWriter.warnOfNoneTopicFormat(atts, attValue) && this.extName != null) {
            return FileUtils.replaceExtension(attValue, this.extName);
        }
        return attValue;
    }

    public DitaWriter() {
        this.classStack = new Stack();
        this.colSpecStack = new Stack();
        this.rowNumStack = new Stack();
        this.columnNumberStack = new Stack();
        this.columnNumberEndStack = new Stack();
        this.rowsMapStack = new Stack();
        this.colSpanMapStack = new Stack();
    }

    public void setFilterUtils(FilterUtils filterUtils) {
        this.filterUtils = filterUtils;
    }

    public void setDelayConrefUtils(DelayConrefUtils delayConrefUtils) {
        this.delayConrefUtils = delayConrefUtils;
    }

    public void setOutputUtils(OutputUtils outputUtils) {
        this.outputUtils = outputUtils;
    }

    public void setKeyDefinitions(Collection<KeyDef> keydefs) {
        this.keys = new HashMap<String, KeyDef>();
        for (KeyDef k : keydefs) {
            this.keys.put(k.keys, k);
        }
    }

    public void initXMLReader(File ditaDir, boolean validate, boolean arg_setSystemid) throws SAXException {
        try {
            this.reader = StringUtils.getXMLReader();
            if (validate) {
                this.reader.setFeature("http://xml.org/sax/features/validation", true);
                try {
                    this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                }
                catch (SAXNotRecognizedException e) {
                    // empty catch block
                }
            }
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            CatalogResolver resolver = CatalogUtils.getCatalogResolver();
            this.setEntityResolver((EntityResolver)resolver);
            this.reader.setEntityResolver((EntityResolver)resolver);
        }
        catch (Exception e) {
            throw new SAXException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
        this.setGrammarPool(this.reader, GrammarPoolManager.getGrammarPool());
        CatalogUtils.setDitaDir(ditaDir);
        this.setSystemid = arg_setSystemid;
    }

    public void setGrammarPool(XMLReader reader, XMLGrammarPool grammarPool) {
        try {
            reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
            this.logger.logInfo("Using Xerces grammar pool for DTD and schema caching.");
        }
        catch (Exception e) {
            this.logger.logWarn("Failed to set Xerces grammar pool for parser: " + e.getMessage());
        }
    }

    private void processAttributes(String qName, Attributes atts, AttributesImpl res) throws IOException {
        int attsLen = atts.getLength();
        boolean conkeyrefValid = false;
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = this.getAttributeValue(qName, attQName, atts.getValue(i));
            String nsUri = atts.getURI(i);
            if (attQName.equals("xtrf") || attQName.equals("xtrc") || attQName.equals(ATTRIBUTE_NAME_COLNAME) || attQName.equals("namest") || attQName.equals("nameend") || "conref".equals(attQName)) continue;
            if ("href".equals(attQName) || "copy-to".equals(attQName)) {
                if (atts.getValue("scope") == null || atts.getValue("scope").equalsIgnoreCase("local")) {
                    attValue = this.replaceHREF(attQName, atts);
                }
                XMLUtils.addOrSetAttribute(res, attQName, attValue);
                continue;
            }
            if ("conkeyref".equals(attQName) && attValue.length() != 0) {
                int sharpIndex = attValue.indexOf("#");
                int slashIndex = attValue.indexOf("/");
                int keyIndex = -1;
                if (sharpIndex != -1) {
                    keyIndex = sharpIndex;
                } else if (slashIndex != -1) {
                    keyIndex = slashIndex;
                }
                if (sharpIndex == -1) {
                    if (keyIndex != -1) {
                        String key = attValue.substring(0, keyIndex);
                        if (key.length() != 0 && this.keys.containsKey(key)) {
                            String tail;
                            KeyDef value = this.keys.get(key);
                            String href = value.href;
                            String updatedHref = this.updateHref(href);
                            String id = attValue.substring(keyIndex + 1);
                            boolean idExported = false;
                            boolean keyrefExported = false;
                            List<Boolean> list = null;
                            if (this.transtype.equals("eclipsehelp")) {
                                list = this.delayConrefUtils.checkExport(href, id, key, this.tempDir);
                                idExported = list.get(0);
                                keyrefExported = list.get(1);
                            }
                            if (idExported && keyrefExported && this.transtype.equals("eclipsehelp")) {
                                XMLUtils.addOrSetAttribute(res, "conkeyref", attValue);
                                continue;
                            }
                            String target = updatedHref;
                            target = this.replaceExtName(target);
                            if (sharpIndex == -1) {
                                tail = target.indexOf("#") == -1 ? attValue.substring(keyIndex).replaceAll("/", "#") : attValue.substring(keyIndex);
                            } else {
                                tail = attValue.substring(keyIndex);
                                if (target.indexOf("#") != -1) {
                                    target = target.substring(0, target.indexOf("#"));
                                }
                            }
                            XMLUtils.addOrSetAttribute(res, "conref", target + tail);
                            conkeyrefValid = true;
                            continue;
                        }
                        this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ046E", attValue).toString());
                        continue;
                    }
                    if (this.keys.containsKey(attValue)) {
                        KeyDef value = this.keys.get(attValue);
                        String href = value.href;
                        String updatedHref = this.updateHref(href);
                        String id = null;
                        List<Boolean> list = this.delayConrefUtils.checkExport(href, id, attValue, this.tempDir);
                        boolean keyrefExported = list.get(1);
                        if (keyrefExported && this.transtype.equals("eclipsehelp")) {
                            XMLUtils.addOrSetAttribute(res, "conkeyref", attValue);
                            continue;
                        }
                        String target = updatedHref;
                        target = this.replaceExtName(target);
                        XMLUtils.addOrSetAttribute(res, "conref", target);
                        conkeyrefValid = true;
                        continue;
                    }
                    this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ046E", attValue).toString());
                    continue;
                }
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ046E", attValue).toString());
                continue;
            }
            XMLUtils.addOrSetAttribute(res, nsUri, atts.getLocalName(i), attQName, atts.getType(i), attValue);
        }
        String conref = atts.getValue("conref");
        if (conref != null && !conkeyrefValid) {
            conref = this.replaceCONREF(atts);
            XMLUtils.addOrSetAttribute(res, "conref", conref);
        }
    }

    private String getAttributeValue(String elemQName, String attQName, String value) {
        String defaultValue;
        Map<String, String> defaultMap;
        if (StringUtils.isEmptyString(value) && this.defaultValueMap != null && (defaultMap = this.defaultValueMap.get(attQName)) != null && (defaultValue = defaultMap.get(elemQName)) != null) {
            return defaultValue;
        }
        return value;
    }

    private String replaceExtName(String target) {
        String fileName;
        if (this.extName != null && FileUtils.isDITATopicFile(fileName = FileUtils.resolveFile("", target))) {
            target = FileUtils.replaceExtension(target, this.extName);
        }
        return target;
    }

    private String updateHref(String href) {
        String filePath = new File(this.tempDir, this.inputFile).getAbsolutePath();
        String keyValue = new File(this.tempDir, href).getAbsolutePath();
        String updatedHref = FileUtils.getRelativePath(filePath, keyValue);
        return updatedHref;
    }

    private AttributesImpl copyElementName(String qName, Attributes atts) throws IOException {
        AttributesImpl res = new AttributesImpl();
        String cls = this.classStack.peek();
        if (Constants.TOPIC_TGROUP.matches(cls)) {
            if (this.colSpec != null) {
                this.colSpecStack.push(this.colSpec);
                this.rowNumStack.push(this.rowNumber);
                this.columnNumberStack.push(this.columnNumber);
                this.columnNumberEndStack.push(this.columnNumberEnd);
                this.rowsMapStack.push(this.rowsMap);
                this.colSpanMapStack.push(this.colSpanMap);
            }
            this.columnNumber = 1;
            this.columnNumberEnd = 0;
            this.rowsMap = new HashMap<String, Integer>();
            this.colSpanMap = new HashMap<String, Integer>();
            this.colSpec = new ArrayList<String>(16);
            this.rowNumber = 0;
        } else if (Constants.TOPIC_ROW.matches(cls)) {
            this.columnNumber = 1;
            this.columnNumberEnd = 0;
            ++this.rowNumber;
        } else if (Constants.TOPIC_COLSPEC.matches(cls)) {
            this.columnNumber = this.columnNumberEnd + 1;
            if (atts.getValue(ATTRIBUTE_NAME_COLNAME) != null) {
                this.colSpec.add(atts.getValue(ATTRIBUTE_NAME_COLNAME));
            } else {
                this.colSpec.add(COLUMN_NAME_COL + this.columnNumber);
            }
            this.columnNumberEnd = this.columnNumber;
            XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNAME, COLUMN_NAME_COL + this.columnNumber);
            this.totalColumns = this.columnNumberEnd;
        } else if (Constants.TOPIC_ENTRY.matches(cls)) {
            this.columnNumber = this.getStartNumber(atts, this.columnNumberEnd);
            if (this.columnNumber > this.columnNumberEnd) {
                if (this.rowNumber == 1) {
                    XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNAME, COLUMN_NAME_COL + this.columnNumber);
                    if (atts.getValue("namest") != null) {
                        XMLUtils.addOrSetAttribute(res, "namest", COLUMN_NAME_COL + this.columnNumber);
                    }
                    if (atts.getValue("nameend") != null) {
                        XMLUtils.addOrSetAttribute(res, "nameend", COLUMN_NAME_COL + this.getEndNumber(atts, this.columnNumber));
                    }
                } else {
                    int offset = 0;
                    int currentCol = this.columnNumber;
                    while (currentCol <= this.totalColumns) {
                        int previous_offset = offset;
                        for (int row = 1; row < this.rowNumber; ++row) {
                            int totalSpanRows;
                            String pos = String.valueOf(row) + "-" + String.valueOf(currentCol);
                            if (!this.rowsMap.containsKey(pos) || this.rowNumber > (totalSpanRows = this.rowsMap.get(pos).intValue())) continue;
                            offset += this.colSpanMap.get(pos).intValue();
                        }
                        if (offset <= previous_offset) break;
                        currentCol = this.columnNumber + offset;
                        previous_offset = offset;
                    }
                    this.columnNumber += offset;
                    if (atts.getValue("morerows") != null) {
                        String pos = String.valueOf(this.rowNumber) + "-" + String.valueOf(this.columnNumber);
                        int total = Integer.parseInt(atts.getValue("morerows")) + this.rowNumber;
                        this.rowsMap.put(pos, total);
                        this.colSpanMap.put(pos, this.getColumnSpan(atts));
                    }
                    XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNAME, COLUMN_NAME_COL + this.columnNumber);
                    if (atts.getValue("namest") != null) {
                        XMLUtils.addOrSetAttribute(res, "namest", COLUMN_NAME_COL + this.columnNumber);
                    }
                    if (atts.getValue("nameend") != null) {
                        XMLUtils.addOrSetAttribute(res, "nameend", COLUMN_NAME_COL + this.getEndNumber(atts, this.columnNumber));
                    }
                }
            }
            this.columnNumberEnd = this.getEndNumber(atts, this.columnNumber);
        }
        return res;
    }

    private int getColumnSpan(Attributes atts) {
        if (atts.getValue("namest") == null || atts.getValue("nameend") == null) {
            return 1;
        }
        int ret = this.colSpec.indexOf(atts.getValue("nameend")) - this.colSpec.indexOf(atts.getValue("namest")) + 1;
        if (ret <= 0) {
            return 1;
        }
        return ret;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.getContentHandler().endDocument();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        this.classStack.clear();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.foreignLevel > 0) {
            --this.foreignLevel;
        }
        this.getContentHandler().endElement(uri, localName, qName);
        if (Constants.TOPIC_TGROUP.matches(this.classStack.peek())) {
            if (!this.colSpecStack.isEmpty()) {
                this.colSpec = this.colSpecStack.peek();
                this.rowNumber = this.rowNumStack.peek();
                this.columnNumber = this.columnNumberStack.peek();
                this.columnNumberEnd = this.columnNumberEndStack.peek();
                this.rowsMap = this.rowsMapStack.peek();
                this.colSpanMap = this.colSpanMapStack.peek();
                this.colSpecStack.pop();
                this.rowNumStack.pop();
                this.columnNumberStack.pop();
                this.columnNumberEndStack.pop();
                this.rowsMapStack.pop();
                this.colSpanMapStack.pop();
            } else {
                this.colSpec = null;
                this.rowNumber = 0;
                this.columnNumber = 1;
                this.columnNumberEnd = 0;
                this.rowsMap = null;
                this.colSpanMap = null;
            }
        }
        this.classStack.pop();
    }

    private int getEndNumber(Attributes atts, int columnStart) {
        if (atts.getValue("nameend") == null) {
            return columnStart;
        }
        int ret = this.colSpec.indexOf(atts.getValue("nameend")) + 1;
        if (ret == 0) {
            return columnStart;
        }
        return ret;
    }

    private int getStartNumber(Attributes atts, int previousEnd) {
        if (atts.getValue(ATTRIBUTE_NAME_COLNUM) != null) {
            return new Integer(atts.getValue(ATTRIBUTE_NAME_COLNUM));
        }
        if (atts.getValue("namest") != null) {
            int ret = this.colSpec.indexOf(atts.getValue("namest")) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        if (atts.getValue(ATTRIBUTE_NAME_COLNAME) != null) {
            int ret = this.colSpec.indexOf(atts.getValue(ATTRIBUTE_NAME_COLNAME)) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        return previousEnd + 1;
    }

    public void setTempDir(File tempDir) {
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory '" + tempDir.toString() + "' must be an absolute path");
        }
        this.tempDir = tempDir;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.getContentHandler().startDocument();
            if (Constants.OS_NAME.toLowerCase().indexOf("windows") == -1) {
                this.getContentHandler().processingInstruction(PI_WORKDIR_TARGET, this.absolutePath.getCanonicalPath());
            } else {
                this.getContentHandler().processingInstruction(PI_WORKDIR_TARGET, "/" + this.absolutePath.getCanonicalPath());
            }
            this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
            this.getContentHandler().processingInstruction(PI_WORKDIR_TARGET_URI, this.absolutePath.toURI().toASCIIString());
            this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
            if (this.path2Project != null) {
                this.getContentHandler().processingInstruction(PI_PATH2PROJ_TARGET, this.path2Project);
                this.getContentHandler().processingInstruction(PI_PATH2PROJ_TARGET_URI, URLUtils.correct(FileUtils.separatorsToUnix(this.path2Project), true));
            } else {
                this.getContentHandler().processingInstruction(PI_PATH2PROJ_TARGET, "");
                this.getContentHandler().processingInstruction(PI_PATH2PROJ_TARGET_URI, "./");
            }
            this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Integer nextValue;
        this.classStack.push(atts.getValue("class"));
        if (this.foreignLevel > 0) {
            ++this.foreignLevel;
        } else if (this.foreignLevel == 0) {
            String attrValue = atts.getValue("class");
            if (attrValue == null && !"dita".equals(localName)) {
                this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ030I", localName).toString());
            }
            if (attrValue != null && (Constants.TOPIC_FOREIGN.matches(attrValue) || Constants.TOPIC_UNKNOWN.matches(attrValue))) {
                this.foreignLevel = 1;
            }
        }
        if (this.counterMap.containsKey(qName)) {
            Integer value = this.counterMap.get(qName);
            nextValue = value + 1;
        } else {
            nextValue = 1;
        }
        this.counterMap.put(qName, nextValue);
        try {
            AttributesImpl res = this.copyElementName(qName, atts);
            this.processAttributes(qName, atts, res);
            if (this.foreignLevel <= 1 && this.genDebugInfo) {
                XMLUtils.addOrSetAttribute(res, "xtrf", this.traceFilename.getAbsolutePath());
                StringBuilder xtrc = new StringBuilder(qName).append(":").append(nextValue.toString());
                if (this.locator != null) {
                    xtrc.append(';').append(Integer.toString(this.locator.getLineNumber())).append(":").append(Integer.toString(this.locator.getColumnNumber()));
                }
                XMLUtils.addOrSetAttribute(res, "xtrc", xtrc.toString());
            }
            this.getContentHandler().startElement(uri, localName, qName, res);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.getContentHandler().characters(ch, start, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File baseDir, String inFile) {
        this.inputFile = inFile;
        OutputStream out = null;
        try {
            this.traceFilename = new File(baseDir, this.inputFile);
            File outputFile = new File(this.tempDir, this.inputFile);
            if (this.extName != null) {
                outputFile = FileUtils.isDITAMapFile(this.inputFile.toLowerCase()) ? new File(this.tempDir, this.inputFile) : new File(this.tempDir, FileUtils.replaceExtension(this.inputFile, this.extName));
            }
            this.path2Project = this.getPathtoProject(this.inputFile, this.traceFilename, this.outputUtils.getInputMapPathName().getAbsolutePath());
            this.counterMap = new HashMap<String, Integer>();
            File dirFile = outputFile.getParentFile();
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            this.absolutePath = dirFile;
            out = new FileOutputStream(outputFile);
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(this.traceFilename.getAbsolutePath(), this.logger));
            InputSource is = new InputSource(this.traceFilename.toURI().toASCIIString());
            if (this.setSystemid) {
                is.setSystemId(this.traceFilename.toURI().toASCIIString());
            }
            this.setContentHandler(null);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            XMLReader xmlSource = this.reader;
            if (this.filterUtils != null) {
                ProfilingFilter profilingFilter = new ProfilingFilter();
                profilingFilter.setLogger(this.logger);
                profilingFilter.setFilterUtils(this.filterUtils);
                profilingFilter.setTranstype(this.transtype);
                profilingFilter.setParent(xmlSource);
                profilingFilter.setEntityResolver(xmlSource.getEntityResolver());
                xmlSource = profilingFilter;
            }
            ValidationFilter validationFilter = new ValidationFilter();
            validationFilter.setLogger(this.logger);
            validationFilter.setParent(xmlSource);
            validationFilter.setEntityResolver(xmlSource.getEntityResolver());
            validationFilter.setValidateMap(this.validateMap);
            xmlSource = validationFilter;
            this.setParent(xmlSource);
            xmlSource = this;
            SAXSource source = new SAXSource(xmlSource, is);
            StreamResult result = new StreamResult(out);
            serializer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    public String getPathtoProject(String filename, File traceFilename, String inputMap) {
        String path2Project = null;
        if (OutputUtils.getGeneratecopyouter() != OutputUtils.Generate.OLDSOLUTION) {
            if (this.isOutFile(traceFilename, inputMap)) {
                path2Project = this.getRelativePathFromOut(traceFilename.getAbsolutePath());
            } else {
                path2Project = FileUtils.getRelativePath(traceFilename.getAbsolutePath(), inputMap);
                if ((path2Project = new File(path2Project).getParent()) != null && path2Project.length() > 0) {
                    path2Project = path2Project + File.separator;
                }
            }
        } else {
            path2Project = FileUtils.getRelativePath(filename);
        }
        return path2Project;
    }

    public String getRelativePathFromOut(String overflowingFile) {
        File mapPathName = this.outputUtils.getInputMapPathName();
        File currFilePathName = new File(overflowingFile);
        String relativePath = FileUtils.getRelativePath(mapPathName.toString(), currFilePathName.toString());
        String outputDir = OutputUtils.getOutputDir().getAbsolutePath();
        StringBuffer outputPathName = new StringBuffer(outputDir).append(File.separator).append("index.html");
        String finalOutFilePathName = FileUtils.resolveFile(outputDir, relativePath);
        String finalRelativePathName = FileUtils.getRelativePath(finalOutFilePathName, outputPathName.toString());
        String parentDir = new File(finalRelativePathName).getParent();
        StringBuffer finalRelativePath = new StringBuffer(parentDir);
        if (finalRelativePath.length() > 0) {
            finalRelativePath.append(File.separator);
        } else {
            finalRelativePath.append(".").append(File.separator);
        }
        return finalRelativePath.toString();
    }

    private boolean isOutFile(File filePathName, String inputMap) {
        String relativePath = FileUtils.getRelativePath(inputMap, filePathName.getAbsolutePath());
        return relativePath != null && relativePath.length() != 0 && relativePath.startsWith("..");
    }

    public Map<String, Map<String, Set<String>>> getValidateMap() {
        return this.validateMap;
    }

    public void setValidateMap(Map<String, Map<String, Set<String>>> validateMap) {
        this.validateMap = validateMap;
    }

    public void setDefaultValueMap(Map<String, Map<String, String>> defaultMap) {
        this.defaultValueMap = defaultMap;
    }

    public String getTranstype() {
        return this.transtype;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    public String getExtName() {
        return this.extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    @Override
    public void setContent(Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.getContentHandler().setDocumentLocator(locator);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.getParent().getClass().getName().equals("org.apache.xerces.parsers.SAXParser") && name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.getParent().setProperty(name, new XercesFixLexicalHandler((LexicalHandler)value));
        } else {
            this.getParent().setProperty(name, value);
        }
    }

    private static final class XercesFixLexicalHandler
    implements LexicalHandler {
        private final LexicalHandler lexicalHandler;

        XercesFixLexicalHandler(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        @Override
        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
            char[] buf = new char[arg2];
            System.arraycopy(arg0, arg1, buf, 0, arg2);
            this.lexicalHandler.comment(buf, 0, arg2);
        }

        @Override
        public void endCDATA() throws SAXException {
            this.lexicalHandler.endCDATA();
        }

        @Override
        public void endDTD() throws SAXException {
            this.lexicalHandler.endDTD();
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
            this.lexicalHandler.endEntity(arg0);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.lexicalHandler.startCDATA();
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
            this.lexicalHandler.startDTD(arg0, arg1, arg2);
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
            this.lexicalHandler.startEntity(arg0);
        }
    }
}

