/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.xml.sax.SAXException;

public final class HTMLIndexWriter
extends AbstractExtendDitaWriter {
    @Override
    public void write(String filename) throws DITAOTException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            XMLSerializer serializer = XMLSerializer.newInstance(out);
            Transformer transformer = serializer.getTransformerHandler().getTransformer();
            transformer.setOutputProperty("doctype-public", "-//IETF//DTD HTML//EN");
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("encoding", "UTF-8");
            serializer.writeStartDocument();
            serializer.writeStartElement("html");
            serializer.writeStartElement("head");
            serializer.writeComment("Sitemap 1.0");
            serializer.writeEndElement();
            serializer.writeStartElement("body");
            serializer.writeStartElement("ul");
            String printLetter = "A";
            int termNum = this.termList.size();
            for (int i = 0; i < termNum; ++i) {
                String firstLetter;
                IndexTerm term = (IndexTerm)this.termList.get(i);
                if (i == 0) {
                    printLetter = term.getTermFullName().substring(0, 1);
                    serializer.writeCharacters(printLetter);
                }
                if (!(firstLetter = term.getTermFullName().substring(0, 1)).equals(printLetter)) {
                    printLetter = firstLetter;
                    serializer.writeCharacters(printLetter);
                }
                this.outputIndexTerm(term, serializer);
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLSerializer serializer) throws SAXException {
        List<IndexTermTarget> targets = term.getTargetList();
        List<IndexTerm> subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        serializer.writeStartElement("li");
        if (targets == null || targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
            targetNum = targets.size();
        }
        if (targetNum > 1) {
            serializer.writeCharacters(term.getTermFullName());
        } else {
            IndexTermTarget target = targets.get(0);
            serializer.writeStartElement("a");
            serializer.writeAttribute("href", target.getTargetURI());
            serializer.writeCharacters(term.getTermFullName());
            serializer.writeEndElement();
        }
        if (subTerms != null && subTermNum > 0) {
            serializer.writeStartElement("ul");
            for (int i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = subTerms.get(i);
                this.outputIndexTerm(subTerm, serializer);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void findTargets(IndexTerm term) {
        List<IndexTerm> subTerms = term.getSubTerms();
        List<IndexTermTarget> subTargets = null;
        if (subTerms != null && !subTerms.isEmpty()) {
            for (int i = 0; i < subTerms.size(); ++i) {
                IndexTerm subTerm = subTerms.get(i);
                subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    @Override
    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append(".hhk");
        return indexFilename.toString();
    }
}

