/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ImageMetadataFilter
extends AbstractXMLFilter {
    private static final String ATTR_VERTICAL_DPI = "vertical-dpi";
    private static final String ATTR_HORIZONTAL_DPI = "horizontal-dpi";
    private static final String ATTR_IMAGE_HEIGHT = "image-height";
    private static final String ATTR_IMAGE_WIDTH = "image-width";
    private static final float MM_TO_INCH = 25.4f;
    public static final String DITA_OT_PREFIX = "dita-ot";
    public static final String DITA_OT_NS = "http://dita-ot.sourceforge.net/ns/201007/dita-ot";
    private final File outputDir;
    private final File tempDir;
    private final String uplevels;
    private File currentFile = null;
    private int depth = 0;
    private final Map<File, Attributes> cache = new HashMap<File, Attributes>();

    public ImageMetadataFilter(File outputDir, File tempDir, String uplevels) {
        this.outputDir = outputDir;
        this.tempDir = tempDir;
        this.uplevels = uplevels;
    }

    @Override
    public void setContent(Content content) {
    }

    @Override
    public void write(String filename) throws DITAOTException {
        if (filename == null || !new File(filename).exists()) {
            return;
        }
        this.currentFile = new File(filename);
        this.logger.logInfo("Processing " + filename);
        super.write(filename);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (Constants.TOPIC_IMAGE.matches(atts)) {
            XMLUtils.AttributesBuilder a = new XMLUtils.AttributesBuilder(atts);
            File imgInput = this.getImageFile(atts);
            if (imgInput.exists()) {
                Attributes m = this.cache.get(imgInput);
                if (m == null) {
                    m = this.readMetadata(imgInput);
                    this.cache.put(imgInput, m);
                }
                a.addAll(m);
            }
            this.depth = 1;
            super.startPrefixMapping(DITA_OT_PREFIX, DITA_OT_NS);
            super.startElement(uri, localName, name, a.build());
        } else {
            if (this.depth > 0) {
                ++this.depth;
            }
            super.startElement(uri, localName, name, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.depth > 0) {
            if (this.depth == 1) {
                super.endPrefixMapping(DITA_OT_PREFIX);
            }
            --this.depth;
        }
    }

    private Attributes readMetadata(File imgInput) {
        this.logger.logInfo("Reading " + imgInput);
        XMLUtils.AttributesBuilder a = new XMLUtils.AttributesBuilder();
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(imgInput);
            Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
            if (!i.hasNext()) {
                this.logger.logInfo("Image " + imgInput + " format not supported");
            } else {
                NodeList vs;
                ImageReader r = i.next();
                r.setInput(iis);
                BufferedImage img = r.read(0);
                a.add(DITA_OT_NS, ATTR_IMAGE_WIDTH, "dita-ot:image-width", "CDATA", Integer.toString(img.getWidth()));
                a.add(DITA_OT_NS, ATTR_IMAGE_HEIGHT, "dita-ot:image-height", "CDATA", Integer.toString(img.getHeight()));
                Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
                NodeList hs = node.getElementsByTagName("HorizontalPixelSize");
                if (hs != null && hs.getLength() == 1) {
                    float v = Float.parseFloat(((Element)hs.item(0)).getAttribute("value"));
                    int dpi = Math.round(25.4f / v);
                    a.add(DITA_OT_NS, ATTR_HORIZONTAL_DPI, "dita-ot:horizontal-dpi", "CDATA", Integer.toString(dpi));
                }
                if ((vs = node.getElementsByTagName("VerticalPixelSize")) != null && vs.getLength() == 1) {
                    float v = Float.parseFloat(((Element)vs.item(0)).getAttribute("value"));
                    int dpi = Math.round(25.4f / v);
                    a.add(DITA_OT_NS, ATTR_VERTICAL_DPI, "dita-ot:vertical-dpi", "CDATA", Integer.toString(dpi));
                }
            }
        }
        catch (Exception e) {
            this.logger.logError("Failed to read image " + imgInput + " metadata: " + e.getMessage(), e);
        }
        return a.build();
    }

    private File getImageFile(Attributes atts) {
        String fileDir = this.tempDir.toURI().relativize(this.currentFile.getParentFile().toURI()).toASCIIString();
        StringBuilder fileName = new StringBuilder(fileDir).append("./");
        if (OutputUtils.getGeneratecopyouter() != OutputUtils.Generate.OLDSOLUTION) {
            fileName.append(FileUtils.separatorsToUnix(this.uplevels));
        }
        fileName.append(atts.getValue("href"));
        URI imgInputUri = this.outputDir.toURI().resolve(fileName.toString());
        File imgInput = new File(imgInputUri);
        return imgInput;
    }
}

