/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.xml.sax.SAXException;

public final class JavaHelpIndexWriter
extends AbstractExtendDitaWriter {
    @Override
    public void write(String filename) throws DITAOTException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            XMLSerializer serializer = XMLSerializer.newInstance(out);
            Transformer transformer = serializer.getTransformerHandler().getTransformer();
            transformer.setOutputProperty("doctype-public", "-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://java.sun.com/products/javahelp/index_1_0.dtd");
            serializer.writeStartDocument();
            serializer.writeStartElement("index");
            serializer.writeAttribute("version", "1.0");
            int termNum = this.termList.size();
            for (int i = 0; i < termNum; ++i) {
                IndexTerm term = (IndexTerm)this.termList.get(i);
                this.outputIndexTerm(term, serializer);
            }
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLSerializer serializer) throws SAXException {
        int subTermNum;
        List<IndexTermTarget> targets = term.getTargetList();
        List<IndexTerm> subTerms = term.getSubTerms();
        int targetNum = targets == null ? 0 : targets.size();
        int n = subTermNum = subTerms == null ? 0 : subTerms.size();
        if (subTermNum > 0) {
            serializer.writeStartElement("indexitem");
            serializer.writeAttribute("text", term.getTermFullName());
            for (int i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = subTerms.get(i);
                this.outputIndexTerm(subTerm, serializer);
            }
            serializer.writeEndElement();
        } else {
            for (int i = 0; i < targetNum; ++i) {
                IndexTermTarget target = targets.get(i);
                String targetURL = target.getTargetURI();
                targetURL = targetURL.substring(0, targetURL.lastIndexOf("."));
                targetURL = targetURL.replace('\\', '_');
                targetURL = targetURL.replace('/', '_');
                targetURL = targetURL.replace('.', '_');
                serializer.writeStartElement("indexitem");
                serializer.writeAttribute("text", term.getTermFullName());
                serializer.writeAttribute("target", targetURL);
                serializer.writeEndElement();
            }
        }
    }

    @Override
    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append("_index.xml");
        return indexFilename.toString();
    }
}

