/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class KeyrefPaser
extends AbstractXMLFilter {
    private static final Set<String> no_copy;
    private static final Set<String> no_copy_topic;
    private static final List<KeyrefInfo> keyrefInfos;
    private Map<String, Element> definitionMap;
    private File tempDir;
    private File inputFile;
    private final Stack<Integer> keyrefLevalStack = new Stack();
    private int keyrefLeval = 0;
    private Map<String, String> keyMap;
    private final Stack<Boolean> validKeyref = new Stack();
    private boolean empty = true;
    private final Stack<String> elemName;
    private KeyrefInfo currentElement;
    private boolean hasChecked;
    private final Stack<Boolean> hasSubElem;
    private Element elem;
    private Set<String> normalProcessingRoleTargets;

    public KeyrefPaser() {
        this.keyMap = new HashMap<String, String>();
        this.elemName = new Stack();
        this.hasSubElem = new Stack();
    }

    @Override
    public void setContent(Content content) {
        throw new UnsupportedOperationException();
    }

    public void setKeyDefinition(Map<String, Element> definitionMap) {
        this.definitionMap = definitionMap;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setCurrentFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setKeyMap(Map<String, String> map) {
        this.keyMap = map;
    }

    public Set<String> getNormalProcessingRoleTargets() {
        return Collections.unmodifiableSet(this.normalProcessingRoleTargets);
    }

    @Override
    public void write(String filename) throws DITAOTException {
        super.write(new File(this.tempDir, this.inputFile.getPath()).getAbsolutePath());
    }

    @Override
    public void startDocument() throws SAXException {
        this.normalProcessingRoleTargets = new HashSet<String>();
        this.getContentHandler().startDocument();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.keyrefLeval != 0 && new String(ch, start, length).trim().length() == 0) {
            if (!this.hasChecked) {
                this.empty = true;
            }
        } else {
            this.hasChecked = true;
            this.empty = false;
        }
        this.getContentHandler().characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.keyrefLeval != 0 && this.empty && !this.elemName.peek().equals(Constants.MAP_TOPICREF.localName) && !this.validKeyref.isEmpty() && this.validKeyref.peek().booleanValue()) {
            NodeList nodeList = null;
            if (!name.equals(this.elemName.peek())) {
                nodeList = this.elem.getElementsByTagName(name);
                if (nodeList.getLength() > 0) {
                    Node node = nodeList.item(0);
                    NodeList nList = node.getChildNodes();
                    int index = 0;
                    while (index < nList.getLength()) {
                        Node n;
                        if ((n = nList.item(index++)).getNodeType() != 3) continue;
                        char[] ch = n.getNodeValue().toCharArray();
                        this.getContentHandler().characters(ch, 0, ch.length);
                        break;
                    }
                }
            } else {
                nodeList = this.elem.getElementsByTagName(Constants.TOPIC_KEYWORD.localName);
                if (nodeList.getLength() == 0) {
                    nodeList = this.elem.getElementsByTagName(Constants.TOPIC_TERM.localName);
                }
                if (!this.hasSubElem.peek().booleanValue()) {
                    if (nodeList.getLength() > 0) {
                        if (this.currentElement != null && !this.currentElement.isRefType) {
                            this.domToSax((Element)nodeList.item(0), false);
                        } else if (this.currentElement != null) {
                            if (Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                                AttributesImpl atts = new AttributesImpl();
                                XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_LINKTEXT.toString());
                                this.getContentHandler().startElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName, atts);
                            }
                            if (!this.currentElement.isEmpty) {
                                for (int index = 0; index < nodeList.getLength(); ++index) {
                                    Node node = nodeList.item(index);
                                    if (node.getNodeType() != 1) continue;
                                    this.domToSax((Element)node, true);
                                }
                            }
                            if (Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                                this.getContentHandler().endElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName);
                            }
                        }
                    } else if (this.currentElement != null && Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                        NodeList linktext = this.elem.getElementsByTagName(Constants.TOPIC_LINKTEXT.localName);
                        if (linktext.getLength() > 0) {
                            this.domToSax((Element)linktext.item(0), true);
                        } else if (!StringUtils.isEmptyString(this.elem.getAttribute("navtitle"))) {
                            AttributesImpl atts = new AttributesImpl();
                            XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_LINKTEXT.toString());
                            this.getContentHandler().startElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName, atts);
                            if (this.elem.getAttribute("navtitle") != null) {
                                char[] ch = this.elem.getAttribute("navtitle").toCharArray();
                                this.getContentHandler().characters(ch, 0, ch.length);
                            }
                            this.getContentHandler().endElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName);
                        }
                    } else if (this.currentElement != null && this.currentElement.isRefType) {
                        NodeList linktext = this.elem.getElementsByTagName(Constants.TOPIC_LINKTEXT.localName);
                        if (linktext.getLength() > 0) {
                            this.domToSax((Element)linktext.item(0), false);
                        } else if (this.elem.getAttribute("navtitle") != null) {
                            char[] ch = this.elem.getAttribute("navtitle").toCharArray();
                            this.getContentHandler().characters(ch, 0, ch.length);
                        }
                    }
                }
            }
        }
        if (this.keyrefLeval != 0) {
            --this.keyrefLeval;
            this.empty = false;
        }
        if (this.keyrefLeval == 0 && !this.keyrefLevalStack.empty()) {
            this.keyrefLeval = this.keyrefLevalStack.pop();
            this.validKeyref.pop();
            this.elemName.pop();
            this.hasSubElem.pop();
        }
        this.getContentHandler().endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.currentElement = null;
        String cls = atts.getValue("class");
        for (KeyrefInfo k : keyrefInfos) {
            if (!k.type.matches(cls)) continue;
            this.currentElement = k;
        }
        AttributesImpl resAtts = new AttributesImpl(atts);
        this.hasChecked = false;
        this.empty = true;
        boolean valid = false;
        if (atts.getIndex("keyref") == -1) {
            if (this.keyrefLeval != 0) {
                ++this.keyrefLeval;
                this.hasSubElem.pop();
                this.hasSubElem.push(true);
            }
        } else {
            this.elemName.push(name);
            if (this.keyrefLeval != 0) {
                this.keyrefLevalStack.push(this.keyrefLeval);
                this.hasSubElem.pop();
                this.hasSubElem.push(true);
            }
            this.hasSubElem.push(false);
            this.keyrefLeval = 0;
            ++this.keyrefLeval;
            String keyrefValue = atts.getValue("keyref");
            int slashIndex = keyrefValue.indexOf("/");
            String keyName = keyrefValue;
            String elementId = "";
            if (slashIndex != -1) {
                keyName = keyrefValue.substring(0, slashIndex);
                elementId = keyrefValue.substring(slashIndex);
            }
            this.elem = this.definitionMap.get(keyName);
            if (this.elem != null) {
                NamedNodeMap namedNodeMap = this.elem.getAttributes();
                if (this.currentElement != null && this.currentElement.refAttr != null) {
                    String target = this.keyMap.get(keyName);
                    if (target != null && target.length() != 0) {
                        String target_output = target;
                        String scopeValue = this.elem.getAttribute("scope");
                        String formatValue = this.elem.getAttribute("format");
                        if (Constants.TOPIC_IMAGE.matches(this.currentElement.type)) {
                            valid = true;
                            target_output = FileUtils.getRelativePath(this.inputFile.getPath(), target_output);
                            target_output = KeyrefPaser.normalizeHrefValue(target_output, elementId);
                            XMLUtils.addOrSetAttribute(resAtts, this.currentElement.refAttr, target_output);
                        } else if (("".equals(scopeValue) || "local".equals(scopeValue)) && ("".equals(formatValue) || "dita".equals(formatValue) || "ditamap".equals(formatValue))) {
                            File topicFile = new File(FileUtils.resolveFile(this.tempDir.getAbsolutePath(), URLUtils.decode(target)));
                            if (topicFile.exists()) {
                                String topicId = this.getFirstTopicId(topicFile);
                                target_output = FileUtils.getRelativePath(new File(this.tempDir, this.inputFile.getPath()).getAbsolutePath(), new File(this.tempDir, target).getAbsolutePath());
                                valid = true;
                                target_output = KeyrefPaser.normalizeHrefValue(target_output, elementId, topicId);
                                XMLUtils.addOrSetAttribute(resAtts, this.currentElement.refAttr, target_output);
                                if (!"resource-only".equals(atts.getValue("processing-role"))) {
                                    this.normalProcessingRoleTargets.add(FileUtils.stripFragment(target_output));
                                }
                            }
                        } else {
                            valid = true;
                            target_output = KeyrefPaser.normalizeHrefValue(target_output, elementId);
                            XMLUtils.addOrSetAttribute(resAtts, this.currentElement.refAttr, target_output);
                        }
                    } else if (target == null || target.length() == 0) {
                        valid = true;
                        XMLUtils.removeAttribute(resAtts, "scope");
                        XMLUtils.removeAttribute(resAtts, "href");
                        XMLUtils.removeAttribute(resAtts, "type");
                        XMLUtils.removeAttribute(resAtts, "format");
                    } else {
                        this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ047I", atts.getValue("keyref")).setLocation(atts).toString());
                    }
                } else if (this.currentElement != null && !this.currentElement.isRefType) {
                    valid = true;
                    XMLUtils.removeAttribute(resAtts, "scope");
                    XMLUtils.removeAttribute(resAtts, "href");
                    XMLUtils.removeAttribute(resAtts, "type");
                    XMLUtils.removeAttribute(resAtts, "format");
                }
                if (valid) {
                    Node node;
                    if (this.currentElement != null && Constants.MAP_TOPICREF.matches(this.currentElement.type)) {
                        for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                            node = namedNodeMap.item(index);
                            if (node.getNodeType() != 2 || no_copy.contains(node.getNodeName())) continue;
                            XMLUtils.removeAttribute(resAtts, node.getNodeName());
                            XMLUtils.addOrSetAttribute(resAtts, node);
                        }
                    } else if (this.currentElement != null && this.currentElement.isRefType) {
                        for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                            node = namedNodeMap.item(index);
                            if (node.getNodeType() != 2 || no_copy_topic.contains(node.getNodeName()) || !node.getNodeName().equals(this.currentElement.refAttr) && resAtts.getIndex(node.getNodeName()) != -1) continue;
                            XMLUtils.removeAttribute(resAtts, node.getNodeName());
                            XMLUtils.addOrSetAttribute(resAtts, node);
                        }
                    } else if (this.currentElement != null && !this.currentElement.isRefType) {
                        for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                            node = namedNodeMap.item(index);
                            if (node.getNodeType() != 2 || no_copy_topic.contains(node.getNodeName()) || node.getNodeName().equals("scope") || node.getNodeName().equals("format") || node.getNodeName().equals("type")) continue;
                            XMLUtils.removeAttribute(resAtts, node.getNodeName());
                            XMLUtils.addOrSetAttribute(resAtts, node);
                        }
                    }
                }
            } else {
                this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ047I", atts.getValue("keyref")).setLocation(atts).toString());
            }
            this.validKeyref.push(valid);
        }
        this.getContentHandler().startElement(uri, localName, name, resAtts);
    }

    private void domToSax(Element elem, boolean retainElements) throws SAXException {
        if (retainElements) {
            AttributesImpl atts = new AttributesImpl();
            NamedNodeMap namedNodeMap = elem.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr a = (Attr)namedNodeMap.item(i);
                if (a.getNodeName().equals("class")) {
                    XMLUtils.addOrSetAttribute(atts, "class", this.changeclassValue(a.getNodeValue()));
                    continue;
                }
                XMLUtils.addOrSetAttribute(atts, a);
            }
            this.getContentHandler().startElement("", elem.getNodeName(), elem.getNodeName(), atts);
        }
        NodeList nodeList = elem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                if (Constants.TOPIC_TM.matches(e)) {
                    this.domToSax(e, true);
                    continue;
                }
                this.domToSax(e, retainElements);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            char[] ch = node.getNodeValue().toCharArray();
            this.getContentHandler().characters(ch, 0, ch.length);
        }
        if (retainElements) {
            this.getContentHandler().endElement("", elem.getNodeName(), elem.getNodeName());
        }
    }

    private String changeclassValue(String classValue) {
        DitaClass cls = new DitaClass(classValue);
        if (cls.equals(Constants.MAP_LINKTEXT)) {
            return Constants.TOPIC_LINKTEXT.toString();
        }
        if (cls.equals(Constants.MAP_SEARCHTITLE)) {
            return Constants.TOPIC_SEARCHTITLE.toString();
        }
        if (cls.equals(Constants.MAP_SHORTDESC)) {
            return Constants.TOPIC_SHORTDESC.toString();
        }
        return cls.toString();
    }

    private static String normalizeHrefValue(String keyName, String tail) {
        int sharpIndex = keyName.indexOf("#");
        if (sharpIndex == -1) {
            return keyName + tail.replaceAll("/", "#");
        }
        return keyName + tail;
    }

    private String getFirstTopicId(File topicFile) {
        String path = topicFile.getParent();
        String name = topicFile.getName();
        String topicId = MergeUtils.getFirstTopicId(name, path, false);
        return topicId;
    }

    private static String normalizeHrefValue(String fileName, String tail, String topicId) {
        int sharpIndex = fileName.indexOf("#");
        if (sharpIndex == -1 && !"".equals(tail)) {
            return fileName + "#" + topicId + tail;
        }
        return fileName + tail;
    }

    static {
        HashSet<String> nc = new HashSet<String>();
        nc.add("id");
        nc.add("class");
        nc.add("xtrc");
        nc.add("xtrf");
        nc.add("href");
        nc.add("keys");
        nc.add("toc");
        nc.add("processing-role");
        no_copy = Collections.unmodifiableSet(nc);
        HashSet<String> nct = new HashSet<String>();
        nct.addAll(no_copy);
        nct.add("query");
        nct.add("search");
        nct.add("toc");
        nct.add("print");
        nct.add("copy-to");
        nct.add("chunk");
        nct.add("navtitle");
        no_copy_topic = Collections.unmodifiableSet(nct);
        ArrayList<KeyrefInfo> ki = new ArrayList<KeyrefInfo>();
        ki.add(new KeyrefInfo(Constants.TOPIC_AUTHOR, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_DATA, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_DATA_ABOUT, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_IMAGE, "href", true));
        ki.add(new KeyrefInfo(Constants.TOPIC_LINK, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_LQ, "href", false));
        ki.add(new KeyrefInfo(Constants.MAP_NAVREF, "mapref", true));
        ki.add(new KeyrefInfo(Constants.TOPIC_PUBLISHER, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_SOURCE, "href", false));
        ki.add(new KeyrefInfo(Constants.MAP_TOPICREF, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_XREF, "href", false));
        ki.add(new KeyrefInfo(Constants.TOPIC_CITE, null, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_DT, null, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_KEYWORD, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_TERM, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_PH, null, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEXTERM, null, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEX_BASE, null, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEXTERMREF, null, false));
        keyrefInfos = Collections.unmodifiableList(ki);
    }

    private static final class KeyrefInfo {
        final DitaClass type;
        final String refAttr;
        final boolean isRefType;
        final boolean isEmpty;

        KeyrefInfo(DitaClass type, String refAttr, boolean isEmpty, boolean isRefType) {
            this.type = type;
            this.refAttr = refAttr;
            this.isEmpty = isEmpty;
            this.isRefType = isRefType;
        }

        KeyrefInfo(DitaClass type, String refAttr, boolean isEmpty) {
            this(type, refAttr, isEmpty, refAttr != null);
        }
    }
}

