/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DITAAttrUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ProfilingFilter
extends AbstractXMLFilter {
    private String transtype;
    private boolean exclude;
    private int foreignLevel;
    private int level;
    private String[][] props;
    private final DITAAttrUtils ditaAttrUtils = DITAAttrUtils.getInstance();
    private FilterUtils filterUtils;

    @Override
    public void setContent(Content content) {
        throw new UnsupportedOperationException();
    }

    public void setFilterUtils(FilterUtils filterUtils) {
        this.filterUtils = filterUtils;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.ditaAttrUtils.increasePrintLevel(atts.getValue("print"));
        if (this.ditaAttrUtils.needExcludeForPrintAttri(this.transtype)) {
            return;
        }
        if (this.foreignLevel > 0) {
            ++this.foreignLevel;
        } else if (this.foreignLevel == 0) {
            String classAttr = atts.getValue("class");
            if (classAttr == null && !"dita".equals(localName)) {
                this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ030I", localName).toString());
            }
            if (classAttr != null && (Constants.TOPIC_TOPIC.matches(classAttr) || Constants.MAP_MAP.matches(classAttr))) {
                String domains = atts.getValue("domains");
                if (domains == null) {
                    this.logger.logInfo(MessageUtils.getInstance().getMessage("DOTJ029I", localName).toString());
                } else {
                    this.props = StringUtils.getExtProps(domains);
                }
            }
            if (classAttr != null && (Constants.TOPIC_FOREIGN.matches(classAttr) || Constants.TOPIC_UNKNOWN.matches(classAttr))) {
                this.foreignLevel = 1;
            }
        }
        if (this.exclude) {
            ++this.level;
        } else if (this.foreignLevel <= 1 && this.filterUtils.needExclude(atts, this.props)) {
            this.exclude = true;
            this.level = 0;
        } else {
            this.getContentHandler().startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.ditaAttrUtils.needExcludeForPrintAttri(this.transtype)) {
            this.ditaAttrUtils.decreasePrintLevel();
            return;
        }
        if (this.foreignLevel > 0) {
            --this.foreignLevel;
        }
        if (this.exclude) {
            if (this.level > 0) {
                --this.level;
            } else {
                this.exclude = false;
            }
        } else {
            this.getContentHandler().endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().endDocument();
        }
        this.ditaAttrUtils.reset();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.exclude) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.exclude = false;
        this.foreignLevel = 0;
        this.level = 0;
        this.props = null;
        if (!this.exclude) {
            this.getContentHandler().startDocument();
        }
    }
}

