/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Map;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class TopicRefWriter
extends AbstractXMLWriter {
    private static final String NOT_LOCAL_URL = "://";
    private Map<String, String> changeTable = null;
    private Hashtable<String, String> conflictTable = null;
    private OutputStreamWriter output = null;
    private OutputStreamWriter ditaFileOutput;
    private boolean needResolveEntity;
    private boolean insideCDATA = false;
    private String currentFilePath = null;
    private String currentFilePathName = null;
    private final XMLReader reader;
    private String fixpath = null;

    public TopicRefWriter() {
        try {
            this.reader = StringUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    public void setup(Hashtable<String, String> conflictTable) {
        this.conflictTable = conflictTable;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String tmp;
            if (this.fixpath != null && target.equalsIgnoreCase("workdir")) {
                String tmp2 = this.fixpath.substring(0, this.fixpath.lastIndexOf("/"));
                if (!data.endsWith(tmp2)) {
                    data = data + File.separator + tmp2;
                }
            } else if (this.fixpath != null && target.equals("workdir-uri") && !data.endsWith(tmp = this.fixpath.substring(0, this.fixpath.lastIndexOf("/") + 1))) {
                data = data + tmp;
            }
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logError(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void setContent(Content content) {
        throw new UnsupportedOperationException();
    }

    public void setChangeTable(Map<String, String> changeTable) {
        this.changeTable = changeTable;
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            this.insideCDATA = true;
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.output.write(Constants.LINE_SEPARATOR);
        }
        catch (IOException io) {
            this.logger.logError(io.getMessage(), io);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.copyElementName(qName, atts);
            this.copyElementAttribute(atts);
            this.output.write(">");
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    private void copyAttribute(String attQName, String attValue) throws IOException {
        this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
    }

    private void copyElementAttribute(Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = "href".equals(attQName) ? this.updateHref(attQName, atts) : atts.getValue(i);
            attValue = StringUtils.escapeXML(attValue);
            this.copyAttribute(attQName, attValue);
        }
    }

    private boolean checkDITAHREF(Attributes atts) {
        String classValue = atts.getValue("class");
        String scopeValue = atts.getValue("scope");
        String formatValue = atts.getValue("format");
        if (classValue == null || !Constants.TOPIC_XREF.matches(classValue) && !Constants.TOPIC_LINK.matches(classValue) && !Constants.MAP_TOPICREF.matches(classValue)) {
            return false;
        }
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (formatValue == null) {
            formatValue = "dita";
        }
        return scopeValue.equalsIgnoreCase("local") && formatValue.equalsIgnoreCase("dita");
    }

    private String updateHref(String attQName, Attributes atts) {
        String attValue = null;
        if (attQName == null) {
            return null;
        }
        attValue = atts.getValue(attQName);
        if (attValue == null) {
            return null;
        }
        attValue = FileUtils.separatorsToUnix(attValue);
        if (this.fixpath != null && attValue.startsWith(this.fixpath)) {
            attValue = attValue.substring(this.fixpath.length());
        }
        if (this.changeTable == null || this.changeTable.isEmpty()) {
            return attValue;
        }
        if (this.checkDITAHREF(atts)) {
            String pathtoElem;
            int slashIndex;
            String changeTarget_with_elemt;
            String rootPathName = this.currentFilePathName;
            String changeTargetkey = FileUtils.resolveFile(this.currentFilePath, attValue);
            String changeTarget = this.changeTable.get(changeTargetkey);
            int sharpIndex = attValue.lastIndexOf("#");
            if (sharpIndex != -1 && (changeTarget_with_elemt = this.changeTable.get(changeTargetkey = (slashIndex = attValue.indexOf("/", sharpIndex)) != -1 ? changeTargetkey + attValue.substring(sharpIndex, slashIndex) : changeTargetkey + attValue.substring(sharpIndex))) != null) {
                changeTarget = changeTarget_with_elemt;
            }
            String elementID = this.getElementID(attValue);
            String string = pathtoElem = attValue.contains("#") ? attValue.substring(attValue.indexOf("#") + 1) : "";
            if (StringUtils.isEmptyString(changeTarget)) {
                String absolutePath = FileUtils.resolveTopic(this.currentFilePath, attValue);
                if (absolutePath.contains("#") && absolutePath.substring(absolutePath.indexOf("#")).contains("/")) {
                    absolutePath = absolutePath.substring(0, absolutePath.indexOf("/", absolutePath.indexOf("#")));
                }
                changeTarget = this.changeTable.get(absolutePath);
            }
            if (!this.notTopicFormat(atts, attValue)) {
                if (changeTarget == null) {
                    return attValue;
                }
                String conTarget = this.conflictTable.get(this.removeAnchor(changeTarget));
                if (!StringUtils.isEmptyString(conTarget)) {
                    if (elementID == null) {
                        String idpath = this.getElementID(changeTarget);
                        return FileUtils.getRelativePath(rootPathName, conTarget) + (idpath != null ? "#" + idpath : "");
                    }
                    if (conTarget.contains("#")) {
                        if (!pathtoElem.contains("/")) {
                            return FileUtils.getRelativePath(rootPathName, conTarget);
                        }
                        return FileUtils.getRelativePath(rootPathName, conTarget) + "/" + elementID;
                    }
                    return FileUtils.getRelativePath(rootPathName, conTarget) + "#" + pathtoElem;
                }
                if (elementID == null) {
                    return FileUtils.getRelativePath(rootPathName, changeTarget);
                }
                if (changeTarget.contains("#")) {
                    if (!pathtoElem.contains("/")) {
                        return FileUtils.getRelativePath(rootPathName, changeTarget);
                    }
                    return FileUtils.getRelativePath(rootPathName, changeTarget) + "/" + elementID;
                }
                return FileUtils.getRelativePath(rootPathName, changeTarget) + "#" + pathtoElem;
            }
        }
        return attValue;
    }

    private String removeAnchor(String s) {
        if (s.lastIndexOf("#") != -1) {
            return s.substring(0, s.lastIndexOf("#"));
        }
        return s;
    }

    private String getElementID(String relativePath) {
        String elementID = null;
        String topicWithelement = null;
        if (relativePath.indexOf("#") != -1) {
            topicWithelement = relativePath.substring(relativePath.lastIndexOf("#") + 1);
            elementID = topicWithelement.lastIndexOf("/") != -1 ? topicWithelement.substring(topicWithelement.lastIndexOf("/") + 1) : topicWithelement;
        }
        return elementID;
    }

    private boolean notLocalURL(String valueOfURL) {
        return valueOfURL.indexOf(NOT_LOCAL_URL) != -1;
    }

    private boolean notTopicFormat(Attributes attrs, String valueOfHref) {
        String hrefValue = valueOfHref;
        String formatValue = attrs.getValue("format");
        String extOfHref = FileUtils.getExtension(valueOfHref);
        if (this.notLocalURL(hrefValue)) {
            return true;
        }
        return formatValue == null && extOfHref != null && !extOfHref.equalsIgnoreCase("DITA") && !extOfHref.equalsIgnoreCase("XML");
    }

    private void copyElementName(String qName, Attributes atts) throws IOException {
        this.output.write("<" + qName);
    }

    public void write(String tempDir, String topicfile, Map relativePath2fix) throws DITAOTException {
        if (relativePath2fix.containsKey(topicfile)) {
            this.fixpath = (String)relativePath2fix.get(topicfile);
        }
        this.write(new File(tempDir, topicfile).getAbsolutePath());
        this.fixpath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String outputFilename) throws DITAOTException {
        String filename = outputFilename;
        String file = null;
        this.currentFilePathName = new File(outputFilename).getAbsolutePath();
        this.currentFilePath = new File(outputFilename).getParent();
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        this.needResolveEntity = true;
        try {
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            if (!(inputFile = new File(file = filename.lastIndexOf("#") != -1 ? filename.substring(0, filename.lastIndexOf("#")) : filename)).exists()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTX008E", file).toString());
                return;
            }
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.output = this.ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file, this.logger));
            this.reader.parse(inputFile.toURI().toString());
            this.output.close();
            if (!inputFile.delete()) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                this.logger.logError(MessageUtils.getInstance().getMessage("DOTJ009E", inputFile.getPath(), outputFile.getPath()).toString());
            }
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), e);
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (Exception e) {
                    this.logger.logError(e.getMessage(), e);
                }
            }
        }
    }
}

