/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ValidationFilter
extends AbstractXMLFilter {
    private final MessageUtils messageUtils = MessageUtils.getInstance();
    private final Set<String> topicIds = new HashSet<String>();
    private Map<String, Map<String, Set<String>>> validateMap = null;
    private Locator locator;

    @Override
    public void setContent(Content content) {
        throw new UnsupportedOperationException();
    }

    public void setValidateMap(Map<String, Map<String, Set<String>>> validateMap) {
        this.validateMap = validateMap;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.getContentHandler().setDocumentLocator(locator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl modified = null;
        modified = this.validateLang(atts, modified);
        this.validateId(atts);
        modified = this.validateHref(atts, modified);
        this.validateKeys(atts);
        this.validateAttributeValues(qName, atts);
        this.getContentHandler().startElement(uri, localName, qName, modified != null ? modified : atts);
    }

    private AttributesImpl validateLang(Attributes atts, AttributesImpl modified) throws SAXException {
        int i;
        AttributesImpl res = modified;
        String lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang != null && (i = lang.indexOf(95)) != -1) {
            if (Configuration.processingMode == Configuration.Mode.STRICT) {
                throw new SAXException(this.messageUtils.getMessage("DOTJ056E", lang).setLocation(this.locator).toString());
            }
            this.logger.logError(this.messageUtils.getMessage("DOTJ056E", lang).setLocation(this.locator).toString());
            if (Configuration.processingMode == Configuration.Mode.LAX) {
                if (res == null) {
                    res = new AttributesImpl(atts);
                }
                res.setValue(res.getIndex("http://www.w3.org/XML/1998/namespace", "lang"), lang.replace('_', '-'));
            }
        }
        return res;
    }

    private void validateId(Attributes atts) throws SAXException {
        String id;
        String cls = atts.getValue("class");
        if (Constants.TOPIC_TOPIC.matches(cls) || Constants.MAP_MAP.matches(cls)) {
            this.topicIds.clear();
        } else if (!Constants.TOPIC_RESOURCEID.matches(cls) && (id = atts.getValue("id")) != null) {
            if (this.topicIds.contains(id)) {
                if (Configuration.processingMode == Configuration.Mode.STRICT) {
                    throw new SAXException(this.messageUtils.getMessage("DOTJ057E", id).setLocation(this.locator).toString());
                }
                this.logger.logWarn(this.messageUtils.getMessage("DOTJ057E", id).setLocation(this.locator).toString());
            }
            this.topicIds.add(id);
        }
    }

    private AttributesImpl validateHref(Attributes atts, AttributesImpl modified) {
        AttributesImpl res = modified;
        String href = atts.getValue("href");
        if (href != null) {
            try {
                new URI(href);
            }
            catch (URISyntaxException e) {
                switch (Configuration.processingMode) {
                    case STRICT: {
                        throw new RuntimeException(this.messageUtils.getMessage("DOTJ054E", "href", href).setLocation(this.locator) + ": " + e.getMessage(), e);
                    }
                    case SKIP: {
                        this.logger.logError(this.messageUtils.getMessage("DOTJ054E", "href", href).setLocation(this.locator) + ", using invalid value.");
                        break;
                    }
                    case LAX: {
                        try {
                            String u = new URI(URLUtils.clean(FileUtils.separatorsToUnix(href))).toASCIIString();
                            if (res == null) {
                                res = new AttributesImpl(atts);
                            }
                            res.setValue(res.getIndex("href"), u);
                            this.logger.logError(this.messageUtils.getMessage("DOTJ054E", "href", href).setLocation(this.locator) + ", using '" + u + "'.");
                            break;
                        }
                        catch (URISyntaxException e1) {
                            this.logger.logError(this.messageUtils.getMessage("DOTJ054E", "href", href).setLocation(this.locator) + ", using invalid value.");
                        }
                    }
                }
            }
        }
        return res;
    }

    private void validateAttributeValues(String qName, Attributes atts) {
        if (this.validateMap == null) {
            return;
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String[] keylist;
            String attrName = atts.getQName(i);
            Map<String, Set<String>> valueMap = this.validateMap.get(attrName);
            if (valueMap == null) continue;
            Set<String> valueSet = valueMap.get(qName);
            if (valueSet == null) {
                valueSet = valueMap.get("*");
            }
            if (valueSet == null) continue;
            String attrValue = atts.getValue(i);
            for (String s : keylist = attrValue.trim().split("\\s+")) {
                if (StringUtils.isEmptyString(s) || valueSet.contains(s)) continue;
                this.logger.logWarn(this.messageUtils.getMessage("DOTJ049W", attrName, qName, attrValue, StringUtils.assembleString(valueSet, ",")).toString());
            }
        }
    }

    private void validateKeys(Attributes atts) {
        String keys = atts.getValue("keys");
        if (keys != null) {
            for (String key : keys.split(" ")) {
                if (this.isValidKeyName(key)) continue;
                this.logger.logError(this.messageUtils.getMessage("DOTJ055E", key).toString());
            }
        }
    }

    private boolean isValidKeyName(String key) {
        block4: for (char c : key.toCharArray()) {
            switch (c) {
                case '#': 
                case '/': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    continue block4;
                }
                default: {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

