/*
 * Decompiled with CFR 0.152.
 */
package com.dd;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.Property;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

class CircularAnimatedDrawable
extends Drawable
implements Animatable {
    private static final Interpolator ANGLE_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator SWEEP_INTERPOLATOR = new DecelerateInterpolator();
    private static final int ANGLE_ANIMATOR_DURATION = 2000;
    private static final int SWEEP_ANIMATOR_DURATION = 600;
    public static final int MIN_SWEEP_ANGLE = 30;
    private final RectF fBounds = new RectF();
    private ObjectAnimator mObjectAnimatorSweep;
    private ObjectAnimator mObjectAnimatorAngle;
    private boolean mModeAppearing;
    private Paint mPaint;
    private float mCurrentGlobalAngleOffset;
    private float mCurrentGlobalAngle;
    private float mCurrentSweepAngle;
    private float mBorderWidth;
    private boolean mRunning;
    private Property<CircularAnimatedDrawable, Float> mAngleProperty = new Property<CircularAnimatedDrawable, Float>(Float.class, "angle"){

        public Float get(CircularAnimatedDrawable object) {
            return Float.valueOf(object.getCurrentGlobalAngle());
        }

        public void set(CircularAnimatedDrawable object, Float value) {
            object.setCurrentGlobalAngle(value.floatValue());
        }
    };
    private Property<CircularAnimatedDrawable, Float> mSweepProperty = new Property<CircularAnimatedDrawable, Float>(Float.class, "arc"){

        public Float get(CircularAnimatedDrawable object) {
            return Float.valueOf(object.getCurrentSweepAngle());
        }

        public void set(CircularAnimatedDrawable object, Float value) {
            object.setCurrentSweepAngle(value.floatValue());
        }
    };

    public CircularAnimatedDrawable(int color, float borderWidth) {
        this.mBorderWidth = borderWidth;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(borderWidth);
        this.mPaint.setColor(color);
        this.setupAnimations();
    }

    public void draw(Canvas canvas) {
        float startAngle = this.mCurrentGlobalAngle - this.mCurrentGlobalAngleOffset;
        float sweepAngle = this.mCurrentSweepAngle;
        if (!this.mModeAppearing) {
            startAngle += sweepAngle;
            sweepAngle = 360.0f - sweepAngle - 30.0f;
        } else {
            sweepAngle += 30.0f;
        }
        canvas.drawArc(this.fBounds, startAngle, sweepAngle, false, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    private void toggleAppearingMode() {
        boolean bl = this.mModeAppearing = !this.mModeAppearing;
        if (this.mModeAppearing) {
            this.mCurrentGlobalAngleOffset = (this.mCurrentGlobalAngleOffset + 60.0f) % 360.0f;
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.fBounds.left = (float)bounds.left + this.mBorderWidth / 2.0f + 0.5f;
        this.fBounds.right = (float)bounds.right - this.mBorderWidth / 2.0f - 0.5f;
        this.fBounds.top = (float)bounds.top + this.mBorderWidth / 2.0f + 0.5f;
        this.fBounds.bottom = (float)bounds.bottom - this.mBorderWidth / 2.0f - 0.5f;
    }

    private void setupAnimations() {
        this.mObjectAnimatorAngle = ObjectAnimator.ofFloat((Object)((Object)this), this.mAngleProperty, (float[])new float[]{360.0f});
        this.mObjectAnimatorAngle.setInterpolator((TimeInterpolator)ANGLE_INTERPOLATOR);
        this.mObjectAnimatorAngle.setDuration(2000L);
        this.mObjectAnimatorAngle.setRepeatMode(1);
        this.mObjectAnimatorAngle.setRepeatCount(-1);
        this.mObjectAnimatorSweep = ObjectAnimator.ofFloat((Object)((Object)this), this.mSweepProperty, (float[])new float[]{300.0f});
        this.mObjectAnimatorSweep.setInterpolator((TimeInterpolator)SWEEP_INTERPOLATOR);
        this.mObjectAnimatorSweep.setDuration(600L);
        this.mObjectAnimatorSweep.setRepeatMode(1);
        this.mObjectAnimatorSweep.setRepeatCount(-1);
        this.mObjectAnimatorSweep.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                CircularAnimatedDrawable.this.toggleAppearingMode();
            }
        });
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.mRunning = true;
        this.mObjectAnimatorAngle.start();
        this.mObjectAnimatorSweep.start();
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.mObjectAnimatorAngle.cancel();
        this.mObjectAnimatorSweep.cancel();
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void setCurrentGlobalAngle(float currentGlobalAngle) {
        this.mCurrentGlobalAngle = currentGlobalAngle;
        this.invalidateSelf();
    }

    public float getCurrentGlobalAngle() {
        return this.mCurrentGlobalAngle;
    }

    public void setCurrentSweepAngle(float currentSweepAngle) {
        this.mCurrentSweepAngle = currentSweepAngle;
        this.invalidateSelf();
    }

    public float getCurrentSweepAngle() {
        return this.mCurrentSweepAngle;
    }
}

