/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.repackaged.joptsimple.util;

import com.github.dnault.xmlpatch.repackaged.joptsimple.ValueConversionException;
import com.github.dnault.xmlpatch.repackaged.joptsimple.ValueConverter;
import com.github.dnault.xmlpatch.repackaged.joptsimple.internal.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "com.github.dnault.xmlpatch.repackaged.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

