/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api;

import com.github.dnbn.submerge.api.TimedLinesAPI;
import com.github.dnbn.submerge.api.subtitle.ass.ASSSub;
import com.github.dnbn.submerge.api.subtitle.ass.Events;
import com.github.dnbn.submerge.api.subtitle.common.TimedLine;
import com.github.dnbn.submerge.api.subtitle.common.TimedObject;
import com.github.dnbn.submerge.api.subtitle.common.TimedTextFile;
import com.github.dnbn.submerge.api.subtitle.config.SimpleSubConfig;
import com.github.dnbn.submerge.api.subtitle.srt.SRTLine;
import com.github.dnbn.submerge.api.subtitle.srt.SRTSub;
import com.github.dnbn.submerge.api.subtitle.srt.SRTTime;
import com.github.dnbn.submerge.api.utils.ConvertionUtils;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SubmergeAPI {
    public void convertFramerate(TimedTextFile timedFile, double sourceFramerate, double targetFramerate) {
        double ratio = sourceFramerate / targetFramerate;
        for (TimedLine timedLine : timedFile.getTimedLines()) {
            TimedObject time = timedLine.getTime();
            long s = Math.round((double)time.getStart().toNanoOfDay() * ratio);
            long e = Math.round((double)time.getEnd().toNanoOfDay() * ratio);
            time.setStart(LocalTime.ofNanoOfDay(s));
            time.setEnd(LocalTime.ofNanoOfDay(e));
        }
    }

    public SRTSub toSRT(TimedTextFile timedFile) {
        SRTSub srt = new SRTSub();
        int i = 0;
        for (TimedLine timedLine : timedFile.getTimedLines()) {
            int id = ++i;
            TimedObject time = timedLine.getTime();
            LocalTime start = time.getStart();
            LocalTime end = time.getEnd();
            SRTTime srtTime = new SRTTime(start, end);
            List<String> textLines = timedLine.getTextLines();
            ArrayList<String> newLines = new ArrayList<String>();
            for (String textLine : textLines) {
                newLines.add(ConvertionUtils.toSRTString(textLine));
            }
            SRTLine srtLine = new SRTLine(id, srtTime, newLines);
            srt.add(srtLine);
        }
        return srt;
    }

    public ASSSub toASS(SimpleSubConfig config) {
        return this.mergeToAss(config);
    }

    public ASSSub mergeToAss(SimpleSubConfig ... configs) {
        ASSSub ass = new ASSSub();
        Set<Events> ev = ass.getEvents();
        for (SimpleSubConfig config : configs) {
            ass.getStyle().add(ConvertionUtils.createV4Style(config));
            TimedTextFile sub = config.getSub();
            sub.getTimedLines().forEach(line -> ev.add(ConvertionUtils.createEvent(line, config.getStyleName())));
        }
        return ass;
    }

    public void mergeTextLines(TimedTextFile timedFile) {
        for (TimedLine timedLine : timedFile.getTimedLines()) {
            List<String> textLines = timedLine.getTextLines();
            if (textLines.size() <= 1) continue;
            textLines.set(0, textLines.stream().collect(Collectors.joining(" ")));
            textLines.subList(1, textLines.size()).clear();
        }
    }

    public void adjustTimecodes(TimedTextFile fileToAdjust, TimedTextFile referenceFile, int delay) {
        TimedLinesAPI linesAPI = new TimedLinesAPI();
        ArrayList<? extends TimedLine> timedLines = new ArrayList<TimedLine>(fileToAdjust.getTimedLines());
        ArrayList<? extends TimedLine> referenceLines = new ArrayList<TimedLine>(referenceFile.getTimedLines());
        for (TimedLine timedLine : timedLines) {
            LocalTime targetEnd;
            LocalTime targetStart;
            TimedLine fullIntersect;
            TimedObject originalTime = timedLine.getTime();
            LocalTime originalStart = originalTime.getStart();
            TimedLine referenceLine = linesAPI.closestByStart(referenceLines, originalStart, delay);
            if (referenceLine == null || (fullIntersect = linesAPI.intersected(timedLines, targetStart = referenceLine.getTime().getStart(), targetEnd = referenceLine.getTime().getEnd())) != null && !timedLine.equals(fullIntersect)) continue;
            TimedLine startIntersect = linesAPI.intersected(timedLines, targetStart);
            TimedLine endIntersect = linesAPI.intersected(timedLines, targetEnd);
            if (startIntersect == null || originalTime.equals(startIntersect.getTime())) {
                originalTime.setStart(targetStart);
            } else {
                originalTime.setStart(startIntersect.getTime().getEnd());
            }
            if (endIntersect == null || originalTime.getStart().equals(endIntersect.getTime().getStart())) {
                originalTime.setEnd(targetEnd);
                continue;
            }
            originalTime.setEnd(endIntersect.getTime().getStart());
        }
        SubmergeAPI.expandLongLines(timedLines, referenceLines, 1500);
    }

    private static void expandLongLines(List<? extends TimedLine> adjustedLines, List<? extends TimedLine> referenceLines, int delay) {
        TimedLinesAPI linesAPI = new TimedLinesAPI();
        for (int i = 0; i < adjustedLines.size(); ++i) {
            int nextReferenceIndex;
            TimedObject currentElement = adjustedLines.get(i).getTime();
            int index = linesAPI.findByTime(referenceLines, currentElement);
            if (index < 0 || (nextReferenceIndex = index + 1) >= referenceLines.size() || i + 1 >= adjustedLines.size()) continue;
            TimedObject nextReference = referenceLines.get(nextReferenceIndex).getTime();
            TimedObject nextElement = adjustedLines.get(i + 1).getTime();
            if (!linesAPI.isEqualsOrAfter(currentElement, nextReference) || linesAPI.getDelay(currentElement.getEnd(), nextReference.getStart()) >= delay || !linesAPI.isEqualsOrAfter(nextReference, nextElement)) continue;
            currentElement.setEnd(nextReference.getEnd());
        }
    }
}

