/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api;

import com.github.dnbn.submerge.api.subtitle.common.SubtitleLine;
import com.github.dnbn.submerge.api.subtitle.common.SubtitleTime;
import com.github.dnbn.submerge.api.subtitle.common.TimedLine;
import com.github.dnbn.submerge.api.subtitle.common.TimedObject;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class TimedLinesAPI {
    public TimedLine closestByStart(List<? extends TimedLine> lines, LocalTime time, final int tolerance) {
        TimedLine next;
        TimedLine previous;
        int iAnyMatch = Collections.binarySearch(lines, new SubtitleLine<SubtitleTime>(new SubtitleTime(time, null)), new Comparator<TimedLine>(){

            @Override
            public int compare(TimedLine compare, TimedLine base) {
                LocalTime start;
                LocalTime search = base.getTime().getStart();
                if (TimedLinesAPI.this.getDelay(search, start = compare.getTime().getStart()) < tolerance) {
                    return 0;
                }
                return start.compareTo(search);
            }
        });
        if (iAnyMatch < 0) {
            return null;
        }
        TreeSet<TimedLine> matches = new TreeSet<TimedLine>();
        matches.add(lines.get(iAnyMatch));
        int i = iAnyMatch;
        while (i > 0 && this.getDelay(time, (previous = lines.get(--i)).getTime().getStart()) < tolerance) {
            matches.add(previous);
        }
        i = iAnyMatch;
        while (i < lines.size() - 1 && this.getDelay(time, (next = lines.get(++i)).getTime().getStart()) < tolerance) {
            matches.add(next);
        }
        return (TimedLine)matches.stream().sorted((m1, m2) -> this.getDelay(m1.getTime().getStart(), time) - this.getDelay(m2.getTime().getStart(), time)).findFirst().get();
    }

    public int getDelay(LocalTime start, LocalTime end) {
        return (int)Math.abs(ChronoUnit.MILLIS.between(start, end));
    }

    public boolean isEqualsOrAfter(TimedObject elementToCompare, TimedObject comparedElement) {
        return comparedElement.getStart().isAfter(elementToCompare.getEnd()) || comparedElement.getStart().equals(elementToCompare.getEnd());
    }

    public TimedLine intersected(List<? extends TimedLine> lines, LocalTime time) {
        int index = Collections.binarySearch(lines, new SubtitleLine<SubtitleTime>(new SubtitleTime(time, null)), new Comparator<TimedLine>(){

            @Override
            public int compare(TimedLine compare, TimedLine base) {
                LocalTime search = base.getTime().getStart();
                LocalTime start = compare.getTime().getStart();
                LocalTime end = compare.getTime().getEnd();
                if ((start.isBefore(search) || start.equals(search)) && (end.isAfter(search) || start.equals(search))) {
                    return 0;
                }
                return start.compareTo(search);
            }
        });
        return index < 0 ? null : lines.get(index);
    }

    public TimedLine intersected(List<? extends TimedLine> lines, LocalTime start, LocalTime end) {
        int index = Collections.binarySearch(lines, new SubtitleLine<SubtitleTime>(new SubtitleTime(start, end)), new Comparator<TimedLine>(){

            @Override
            public int compare(TimedLine compare, TimedLine base) {
                LocalTime searchStart = base.getTime().getStart();
                LocalTime searchEnd = base.getTime().getEnd();
                LocalTime start = compare.getTime().getStart();
                LocalTime end = compare.getTime().getEnd();
                if (searchStart.isBefore(start) && searchEnd.isAfter(end)) {
                    return 0;
                }
                return compare.compareTo(base);
            }
        });
        return index < 0 ? null : lines.get(index);
    }

    public int findByTime(List<? extends TimedLine> lines, TimedObject time) {
        return Collections.binarySearch(lines, new SubtitleLine<TimedObject>(time), SubtitleLine.timeComparator);
    }
}

