/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.parser;

import com.github.dnbn.submerge.api.parser.BaseParser;
import com.github.dnbn.submerge.api.parser.exception.InvalidAssSubException;
import com.github.dnbn.submerge.api.subtitle.ass.ASSSub;
import com.github.dnbn.submerge.api.subtitle.ass.ASSTime;
import com.github.dnbn.submerge.api.subtitle.ass.Events;
import com.github.dnbn.submerge.api.subtitle.ass.ScriptInfo;
import com.github.dnbn.submerge.api.subtitle.ass.V4Style;
import com.github.dnbn.submerge.api.utils.ColorUtils;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ASSParser
extends BaseParser<ASSSub> {
    private static final String COMMENTS_MARK = ";";

    @Override
    protected void parse(BufferedReader br, ASSSub sub) throws IOException, InvalidAssSubException {
        String line = ASSParser.readFirstTextLine(br);
        if (line != null && !"[script info]".equalsIgnoreCase(line.trim())) {
            throw new InvalidAssSubException("The line that says \u201c[Script Info]\u201d must be the first line in the script.");
        }
        sub.setScriptInfo(ASSParser.parseScriptInfo(br));
        while ((line = ASSParser.readFirstTextLine(br)) != null) {
            if (line.matches("(?i:^\\[v.*styles\\+?]$)")) {
                sub.setStyle(ASSParser.parseStyle(br));
                continue;
            }
            if (!line.equalsIgnoreCase("[events]")) continue;
            sub.setEvents(ASSParser.parseEvents(br));
        }
        if (sub.getStyle().isEmpty()) {
            throw new InvalidAssSubException("Missing style definition");
        }
        if (sub.getEvents().isEmpty()) {
            throw new InvalidAssSubException("No text line found");
        }
    }

    private static Set<Events> parseEvents(BufferedReader br) throws IOException, InvalidAssSubException {
        String[] eventsFormat = ASSParser.findFormat(br, "events");
        TreeSet<Events> events = new TreeSet<Events>();
        String line = ASSParser.readFirstTextLine(br);
        while (line != null && !line.startsWith("[")) {
            if (line.startsWith("Dialogue: ") && !line.startsWith(COMMENTS_MARK)) {
                int lengthFormat;
                String info = ASSParser.findInfo(line, "Dialogue: ");
                String[] dialogLine = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)info, (String)",");
                int lengthDialog = dialogLine.length;
                if (lengthDialog < (lengthFormat = eventsFormat.length)) {
                    throw new InvalidAssSubException("Incorrect dialog line : " + info);
                }
                if (lengthDialog > lengthFormat) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (int i = lengthFormat - 1; i < lengthDialog; ++i) {
                        joiner.add(dialogLine[i]);
                    }
                    dialogLine[lengthFormat - 1] = joiner.toString();
                    dialogLine = Arrays.copyOfRange(dialogLine, 0, lengthFormat);
                }
                events.add(ASSParser.parseDialog(eventsFormat, dialogLine));
            }
            line = ASSParser.markAndRead(br);
        }
        ASSParser.reset(br, line);
        return events;
    }

    private static List<V4Style> parseStyle(BufferedReader br) throws IOException, InvalidAssSubException {
        String[] styleFormat = ASSParser.findFormat(br, "styles");
        ArrayList<V4Style> styles = new ArrayList<V4Style>();
        String line = ASSParser.readFirstTextLine(br);
        int index = 1;
        while (line != null && !line.startsWith("[")) {
            String[] textLine;
            if (line.startsWith("Style: ") && !line.startsWith(COMMENTS_MARK) && (textLine = line.split(":")).length > 1) {
                String[] styleLine = textLine[1].split(",");
                styles.add(ASSParser.parseV4Style(styleFormat, styleLine, index));
                ++index;
            }
            line = ASSParser.markAndRead(br);
        }
        ASSParser.reset(br, line);
        return styles;
    }

    private static Events parseDialog(String[] eventsFormat, String[] dialogLine) throws InvalidAssSubException {
        Events events = new Events();
        block12: for (int i = 0; i < eventsFormat.length; ++i) {
            String property = StringUtils.uncapitalize((String)eventsFormat[i].trim());
            String value = dialogLine[i].trim();
            try {
                switch (property) {
                    case "start": {
                        ((ASSTime)events.getTime()).setStart(ASSTime.fromString(value));
                        break;
                    }
                    case "end": {
                        ((ASSTime)events.getTime()).setEnd(ASSTime.fromString(value));
                        break;
                    }
                    case "text": {
                        List<String> textLines = Arrays.asList(value.split("\\\\N"));
                        events.setTextLines(new ArrayList<String>(textLines));
                        break;
                    }
                    default: {
                        String error = ASSParser.callProperty(events, property, value);
                        if (error == null) continue block12;
                        throw new InvalidAssSubException("Invalid property (" + property + ") " + value);
                    }
                }
                continue;
            }
            catch (DateTimeException e) {
                throw new InvalidAssSubException("Invalid time for property " + property + " : " + value);
            }
        }
        return events;
    }

    private static V4Style parseV4Style(String[] styleFormat, String[] styleLine, int lineIndex) throws InvalidAssSubException {
        String message = "Style at index " + lineIndex + ": ";
        if (styleFormat.length != styleLine.length) {
            throw new InvalidAssSubException(message + "does not match style definition");
        }
        V4Style style = new V4Style();
        for (int i = 0; i < styleFormat.length; ++i) {
            String error;
            String value;
            String property;
            block6: {
                property = StringUtils.uncapitalize((String)styleFormat[i].trim());
                value = styleLine[i].trim();
                if (property.toLowerCase().indexOf("colour") > -1) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        int bgr = ASSParser.getBGR(value);
                        if (bgr == -1) break block6;
                        value = Integer.toString(bgr);
                    }
                }
            }
            if ((error = ASSParser.callProperty(style, property, value)) == null) continue;
            throw new InvalidAssSubException(message + error);
        }
        if (StringUtils.isEmpty((String)style.getName())) {
            throw new InvalidAssSubException(message + " missing name");
        }
        return style;
    }

    private static int getBGR(String value) {
        int length = value.length();
        int bgr = -1;
        if (length == 10) {
            bgr = ColorUtils.HAABBGGRRToBGR(value);
        } else if (length == 8) {
            bgr = ColorUtils.HBBGGRRToBGR(value);
        }
        return bgr;
    }

    private static ScriptInfo parseScriptInfo(BufferedReader br) throws IOException, InvalidAssSubException {
        ScriptInfo scriptInfo = new ScriptInfo();
        String line = ASSParser.readFirstTextLine(br);
        while (line != null && !line.startsWith("[")) {
            String[] split;
            if (!line.startsWith(COMMENTS_MARK) && (split = line.split(": ")).length > 1) {
                String property = StringUtils.deleteWhitespace((String)split[0]);
                property = StringUtils.uncapitalize((String)property);
                StringJoiner joiner = new StringJoiner(": ");
                for (int i = 1; i < split.length; ++i) {
                    joiner.add(split[i]);
                }
                String value = joiner.toString().trim();
                String error = ASSParser.callProperty(scriptInfo, property, value);
                if (error != null) {
                    throw new InvalidAssSubException("Script info : " + error);
                }
            }
            line = ASSParser.markAndRead(br);
        }
        ASSParser.reset(br, line);
        return scriptInfo;
    }

    private static String callProperty(Object object, String property, String value) {
        String error = null;
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)object, (String)property);
            if (descriptor != null) {
                String type;
                switch (type = descriptor.getPropertyType().getSimpleName()) {
                    case "String": {
                        PropertyUtils.setProperty((Object)object, (String)property, (Object)value);
                        break;
                    }
                    case "int": {
                        PropertyUtils.setProperty((Object)object, (String)property, (Object)NumberUtils.toInt((String)value));
                        break;
                    }
                    case "boolean": {
                        boolean boolValue = NumberUtils.toInt((String)value) == -1;
                        PropertyUtils.setProperty((Object)object, (String)property, (Object)boolValue);
                        break;
                    }
                    case "double": {
                        double doubleValue = NumberUtils.toDouble((String)value.replace(",", ".").trim());
                        PropertyUtils.setProperty((Object)object, (String)property, (Object)doubleValue);
                        break;
                    }
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return error;
    }

    private static String[] findFormat(BufferedReader br, String sectionName) throws IOException, InvalidAssSubException {
        String line = ASSParser.readFirstTextLine(br);
        if (StringUtils.isEmpty((String)line)) {
            throw new InvalidAssSubException("Missing format definition in " + sectionName + " section");
        }
        if (!line.trim().startsWith("Format")) {
            String capitalized = StringUtils.capitalize((String)sectionName);
            throw new InvalidAssSubException(capitalized + " definition must start with 'Format' line");
        }
        return ASSParser.findInfo(line, "Format").split(",");
    }

    private static String findInfo(String line, String search) {
        String info = null;
        String sep = ":";
        if (line.trim().toLowerCase().startsWith(search.toLowerCase()) && line.indexOf(sep) > 0) {
            info = line.substring(line.indexOf(sep) + 1, line.length()).trim();
        }
        return StringUtils.isEmpty(info) ? null : info;
    }
}

