/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.parser;

import com.github.dnbn.submerge.api.parser.SubtitleParser;
import com.github.dnbn.submerge.api.parser.exception.InvalidFileException;
import com.github.dnbn.submerge.api.subtitle.common.TimedTextFile;
import com.github.dnbn.submerge.api.utils.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public abstract class BaseParser<T extends TimedTextFile>
implements SubtitleParser {
    private static final char BOM_MARKER = '\ufeff';

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T parse(File file) {
        if (!file.isFile()) {
            throw new InvalidFileException("File " + file.getName() + " is invalid");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            T t = this.parse(fis, file.getName());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T parse(InputStream is, String fileName) {
        try {
            Type type = this.getClass().getGenericSuperclass();
            TimedTextFile sub = (TimedTextFile)((Class)((ParameterizedType)type).getActualTypeArguments()[0]).newInstance();
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            try (ByteArrayInputStream nis = new ByteArrayInputStream(bytes);
                 InputStreamReader isr = new InputStreamReader((InputStream)nis, FileUtils.guessEncoding(bytes));
                 BufferedReader br = new BufferedReader(isr);){
                BaseParser.skipBom(br);
                sub.setFileName(fileName);
                this.parse(br, sub);
            }
            return (T)sub;
        }
        catch (IOException e) {
            throw new InvalidFileException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void parse(BufferedReader var1, T var2) throws IOException;

    protected static String readFirstTextLine(BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null && StringUtils.isEmpty((String)line.trim())) {
        }
        return line;
    }

    private static void skipBom(BufferedReader br) throws IOException {
        br.mark(4);
        if (65279 != br.read()) {
            br.reset();
        }
    }

    protected static void reset(BufferedReader br, String line) throws IOException {
        if (line != null && line.startsWith("[")) {
            br.reset();
        }
    }

    protected static String markAndRead(BufferedReader br) throws IOException {
        br.mark(32);
        return BaseParser.readFirstTextLine(br);
    }
}

