/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.parser;

import com.github.dnbn.submerge.api.parser.BaseParser;
import com.github.dnbn.submerge.api.parser.exception.InvalidSRTSubException;
import com.github.dnbn.submerge.api.parser.exception.InvalidSubException;
import com.github.dnbn.submerge.api.subtitle.srt.SRTLine;
import com.github.dnbn.submerge.api.subtitle.srt.SRTSub;
import com.github.dnbn.submerge.api.subtitle.srt.SRTTime;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public final class SRTParser
extends BaseParser<SRTSub> {
    @Override
    protected void parse(BufferedReader br, SRTSub sub) throws IOException, InvalidSubException {
        boolean found = true;
        while (found) {
            SRTLine line = SRTParser.firstIn(br);
            found = line != null;
            if (!found) continue;
            sub.add(line);
        }
    }

    private static SRTLine firstIn(BufferedReader br) throws IOException, InvalidSRTSubException {
        String testLine;
        String idLine = SRTParser.readFirstTextLine(br);
        String timeLine = br.readLine();
        if (idLine == null || timeLine == null) {
            return null;
        }
        int id = SRTParser.parseId(idLine);
        SRTTime time = SRTParser.parseTime(timeLine);
        ArrayList<String> textLines = new ArrayList<String>();
        while ((testLine = br.readLine()) != null && !StringUtils.isEmpty((String)testLine.trim())) {
            textLines.add(testLine);
        }
        return new SRTLine(id, time, textLines);
    }

    private static int parseId(String textLine) throws InvalidSRTSubException {
        int idSRTLine;
        try {
            idSRTLine = Integer.parseInt(textLine.trim());
        }
        catch (NumberFormatException e) {
            throw new InvalidSRTSubException("Expected id not found -> " + textLine);
        }
        return idSRTLine;
    }

    private static SRTTime parseTime(String timeLine) throws InvalidSRTSubException {
        SRTTime time = null;
        String[] times = timeLine.split(" --> ".trim());
        if (times.length != 2) {
            throw new InvalidSRTSubException("Subtitle " + timeLine + " - invalid times : " + timeLine);
        }
        try {
            LocalTime start = SRTTime.fromString(times[0]);
            LocalTime end = SRTTime.fromString(times[1]);
            time = new SRTTime(start, end);
        }
        catch (DateTimeParseException e) {
            throw new InvalidSRTSubException("Invalid time string : " + timeLine, e);
        }
        return time;
    }
}

