/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.subtitle.ass;

import com.github.dnbn.submerge.api.subtitle.ass.ASSTime;
import com.github.dnbn.submerge.api.subtitle.common.SubtitleLine;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Events
extends SubtitleLine<ASSTime> {
    private static final long serialVersionUID = -6706119890451628726L;
    public static final String FORMAT_STRING = "Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text";
    private static final String ESCAPED_RETURN = "\\N";
    public static final String DIALOGUE = "Dialogue: ";
    public static final String SEP = ",";
    private int layer;
    private String style;
    private String name = "";
    private String marginL = "0000";
    private String marginR = "0000";
    private String marginV = "0000";
    private String effect = "";

    public Events(String style, ASSTime time, List<String> textLines) {
        this.style = style;
        this.time = time;
        this.textLines = textLines;
    }

    public Events() {
        this.style = "";
        this.time = new ASSTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DIALOGUE);
        sb.append(this.layer).append(SEP);
        sb.append(ASSTime.format(((ASSTime)this.time).getStart())).append(SEP);
        sb.append(ASSTime.format(((ASSTime)this.time).getEnd())).append(SEP);
        sb.append(this.style).append(SEP);
        sb.append(this.name).append(SEP);
        sb.append(this.marginL).append(SEP);
        sb.append(this.marginR).append(SEP);
        sb.append(this.marginV).append(SEP);
        sb.append(this.effect).append(SEP);
        this.textLines.forEach(tl -> sb.append(tl.toString()).append(ESCAPED_RETURN));
        return StringUtils.removeEnd((String)sb.toString(), (String)ESCAPED_RETURN);
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMarginL() {
        return this.marginL;
    }

    public void setMarginL(String marginL) {
        this.marginL = marginL;
    }

    public String getMarginR() {
        return this.marginR;
    }

    public void setMarginR(String marginR) {
        this.marginR = marginR;
    }

    public String getMarginV() {
        return this.marginV;
    }

    public void setMarginV(String marginV) {
        this.marginV = marginV;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }
}

