/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.subtitle.ass;

import java.io.Serializable;
import java.text.DecimalFormat;

public class ScriptInfo
implements Serializable {
    private static final long serialVersionUID = -6613873382621648995L;
    private static final String TIMER = "Timer";
    private static final String PLAY_DEPTH = "PlayDepth";
    private static final String PLAY_RES_X = "PlayResX";
    private static final String PLAY_RES_Y = "PlayResY";
    private static final String COLLISIONS = "Collisions";
    private static final String SCRIPT_TYPE = "ScriptType";
    private static final String UPDATE_DETAILS = "Update Details";
    private static final String SCRIPT_UPDATED_BY = "Script Updated By";
    private static final String SYNCH_POINT = "Synch Point";
    private static final String ORIGINAL_TIMING = "Original Timing";
    private static final String ORIGINAL_EDITING = "Original Editing";
    private static final String ORIGINAL_TRANSLATION = "Original Translation";
    private static final String ORIGINAL_SCRIPT = "Original Script";
    private static final String TITLE = "Title";
    public static final String SEP = ": ";
    private static final String NEW_LINE = "\n";
    private static final DecimalFormat timeFormatter = new DecimalFormat("#.0000");
    private String title;
    private String originalScript;
    private String originalTranslation;
    private String originalEditing;
    private String originalTiming;
    private String synchPoint;
    private String originalScriptChecking;
    private String scriptUpdatedBy;
    private String userDetails;
    private String scriptType = "v4.00+";
    private Collision collisions = Collision.NORMAL;
    private int playResY;
    private int playResX;
    private int playDepth;
    private double timer = 100.0;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ScriptInfo.appendNotNull(sb, TITLE, this.title);
        ScriptInfo.appendNotNull(sb, ORIGINAL_SCRIPT, this.originalScript);
        ScriptInfo.appendNotNull(sb, ORIGINAL_TRANSLATION, this.originalTranslation);
        ScriptInfo.appendNotNull(sb, ORIGINAL_EDITING, this.originalEditing);
        ScriptInfo.appendNotNull(sb, ORIGINAL_TIMING, this.originalTiming);
        ScriptInfo.appendNotNull(sb, SYNCH_POINT, this.synchPoint);
        ScriptInfo.appendNotNull(sb, SCRIPT_UPDATED_BY, this.scriptUpdatedBy);
        ScriptInfo.appendNotNull(sb, UPDATE_DETAILS, this.userDetails);
        ScriptInfo.appendNotNull(sb, SCRIPT_TYPE, this.scriptType);
        ScriptInfo.appendNotNull(sb, COLLISIONS, this.collisions.toString());
        ScriptInfo.appendPositive(sb, PLAY_RES_Y, this.playResY);
        ScriptInfo.appendPositive(sb, PLAY_RES_X, this.playResX);
        ScriptInfo.appendPositive(sb, PLAY_DEPTH, this.playDepth);
        sb.append(TIMER).append(SEP).append(timeFormatter.format(this.timer));
        return sb.toString();
    }

    private static void appendNotNull(StringBuilder sb, String desc, String val) {
        if (val != null) {
            sb.append(desc).append(SEP).append(val).append(NEW_LINE);
        }
    }

    private static void appendPositive(StringBuilder sb, String desc, int val) {
        if (val > 0) {
            sb.append(desc).append(SEP).append(Integer.toString(val)).append(NEW_LINE);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOriginalScript() {
        return this.originalScript;
    }

    public void setOriginalScript(String originalScript) {
        this.originalScript = originalScript;
    }

    public String getOriginalTranslation() {
        return this.originalTranslation;
    }

    public void setOriginalTranslation(String originalTranslation) {
        this.originalTranslation = originalTranslation;
    }

    public String getOriginalEditing() {
        return this.originalEditing;
    }

    public void setOriginalEditing(String originalEditing) {
        this.originalEditing = originalEditing;
    }

    public String getOriginalTiming() {
        return this.originalTiming;
    }

    public void setOriginalTiming(String originalTiming) {
        this.originalTiming = originalTiming;
    }

    public String getSynchPoint() {
        return this.synchPoint;
    }

    public void setSynchPoint(String synchPoint) {
        this.synchPoint = synchPoint;
    }

    public String getOriginalScriptChecking() {
        return this.originalScriptChecking;
    }

    public void setOriginalScriptChecking(String originalScriptChecking) {
        this.originalScriptChecking = originalScriptChecking;
    }

    public String getScriptUpdatedBy() {
        return this.scriptUpdatedBy;
    }

    public void setScriptUpdatedBy(String scriptUpdatedBy) {
        this.scriptUpdatedBy = scriptUpdatedBy;
    }

    public String getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(String userDetails) {
        this.userDetails = userDetails;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(String scriptType) {
        this.scriptType = scriptType;
    }

    public Collision getCollisions() {
        return this.collisions;
    }

    public void setCollisions(Collision collisions) {
        this.collisions = collisions;
    }

    public int getPlayResY() {
        return this.playResY;
    }

    public void setPlayResY(int playResY) {
        this.playResY = playResY;
    }

    public int getPlayResX() {
        return this.playResX;
    }

    public void setPlayResX(int playResX) {
        this.playResX = playResX;
    }

    public int getPlayDepth() {
        return this.playDepth;
    }

    public void setPlayDepth(int playDepth) {
        this.playDepth = playDepth;
    }

    public double getTimer() {
        return this.timer;
    }

    public void setTimer(double timer) {
        this.timer = timer;
    }

    public static enum Collision {
        NORMAL("Normal"),
        REVERSE("Reverse");

        private String type;

        private Collision(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

