/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.subtitle.common;

import com.github.dnbn.submerge.api.subtitle.common.TimedLine;
import com.github.dnbn.submerge.api.subtitle.common.TimedObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SubtitleLine<T extends TimedObject>
implements TimedLine {
    private static final long serialVersionUID = 288560648398584309L;
    protected List<String> textLines = new ArrayList<String>();
    protected T time;
    public static Comparator<TimedLine> timeComparator = new Comparator<TimedLine>(){

        @Override
        public int compare(TimedLine o1, TimedLine o2) {
            return o1.getTime().compareTo(o2.getTime());
        }
    };

    public SubtitleLine() {
    }

    public SubtitleLine(T time) {
        this.time = time;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimedLine other = (TimedLine)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compare(TimedLine o1, TimedLine o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compareTo(TimedLine o) {
        int compare = this.time.compareTo((TimedObject)o.getTime());
        if (compare == 0) {
            String thisText = String.join((CharSequence)",", this.textLines);
            String otherText = String.join((CharSequence)",", o.getTextLines());
            compare = thisText.compareTo(otherText);
        }
        return compare;
    }

    public T getTime() {
        return this.time;
    }

    public void setTime(T time) {
        this.time = time;
    }

    @Override
    public List<String> getTextLines() {
        return this.textLines;
    }

    public void setTextLines(List<String> textLines) {
        this.textLines = textLines;
    }
}

