/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.subtitle.srt;

import com.github.dnbn.submerge.api.subtitle.common.SubtitleTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class SRTTime
extends SubtitleTime {
    private static final long serialVersionUID = -5787808223967579723L;
    public static DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss,SSS");
    public static final String PATTERN = "HH:mm:ss,SSS";
    private static final String TS_PATTERN = "%02d:%02d:%02d,%03d";
    public static final String DELIMITER = " --> ";

    public SRTTime() {
    }

    public SRTTime(LocalTime start, LocalTime end) {
        super(start, end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SRTTime.format(this.start));
        sb.append(DELIMITER);
        sb.append(SRTTime.format(this.end));
        return sb.toString();
    }

    public static String format(LocalTime time) {
        int hr = time.get(ChronoField.HOUR_OF_DAY);
        int min = time.get(ChronoField.MINUTE_OF_HOUR);
        int sec = time.get(ChronoField.SECOND_OF_MINUTE);
        int ms = time.get(ChronoField.MILLI_OF_SECOND);
        return String.format(TS_PATTERN, hr, min, sec, ms);
    }

    public static LocalTime fromString(String times) {
        return LocalTime.parse(times.replace('.', ',').trim(), FORMATTER);
    }
}

