/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.utils;

import com.github.dnbn.submerge.api.parser.exception.InvalidColorCode;
import java.awt.Color;

public final class ColorUtils {
    public static int hexToBGR(String hex) {
        Color color = Color.decode(hex);
        int in = Integer.decode(Integer.toString(color.getRGB()));
        int red = in >> 16 & 0xFF;
        int green = in >> 8 & 0xFF;
        int blue = in >> 0 & 0xFF;
        return blue << 16 | green << 8 | red << 0;
    }

    public static String HAABBGGRRToHex(String haabbggrr) {
        if (haabbggrr.length() != 10) {
            throw new InvalidColorCode("Invalid pattern, must be &HAABBGGRR");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(haabbggrr.substring(8));
        sb.append(haabbggrr.substring(6, 7));
        sb.append(haabbggrr.substring(4, 5));
        sb.append(haabbggrr.substring(2, 3));
        return sb.toString().toLowerCase();
    }

    public static String HBBGGRRToHex(String hbbggrr) {
        if (hbbggrr.length() != 8) {
            throw new InvalidColorCode("Invalid pattern, must be &HBBGGRR");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(hbbggrr.substring(6));
        sb.append(hbbggrr.substring(4, 5));
        sb.append(hbbggrr.substring(2, 3));
        return sb.toString().toLowerCase();
    }

    public static int HAABBGGRRToBGR(String haabbggrr) {
        return ColorUtils.hexToBGR(ColorUtils.HAABBGGRRToHex(haabbggrr));
    }

    public static int HBBGGRRToBGR(String hbbggrr) {
        return ColorUtils.hexToBGR(ColorUtils.HBBGGRRToHex(hbbggrr));
    }
}

