/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.utils;

import com.github.dnbn.submerge.api.subtitle.ass.ASSTime;
import com.github.dnbn.submerge.api.subtitle.ass.Events;
import com.github.dnbn.submerge.api.subtitle.ass.V4Style;
import com.github.dnbn.submerge.api.subtitle.common.TimedLine;
import com.github.dnbn.submerge.api.subtitle.common.TimedObject;
import com.github.dnbn.submerge.api.subtitle.config.Font;
import com.github.dnbn.submerge.api.subtitle.config.SimpleSubConfig;
import com.github.dnbn.submerge.api.utils.ColorUtils;
import java.util.ArrayList;

public class ConvertionUtils {
    private static final String RGX_XML_TAG = "<[^>]+>";
    private static final String RGX_ASS_FORMATTING = "\\{[^\\}]*\\}";
    private static final String SRT_ITALIC_CLOSE = "\\</i\\>";
    private static final String SRT_ITALIC_OPEN = "\\<i\\>";
    private static final String ASS_ITALIC_CLOSE = "\\{\\\\i0\\}";
    private static final String ASS_ITALIC_OPEN = "\\{\\\\i1\\}";

    public static Events createEvent(TimedLine line, String style) {
        ArrayList<String> newLine = new ArrayList<String>();
        for (String text : line.getTextLines()) {
            newLine.add(ConvertionUtils.toASSString(text));
        }
        TimedObject timeLine = line.getTime();
        ASSTime time = new ASSTime(timeLine.getStart(), timeLine.getEnd());
        return new Events(style, time, newLine);
    }

    public static V4Style createV4Style(SimpleSubConfig config) {
        V4Style style = new V4Style(config.getStyleName());
        Font font = config.getFontconfig();
        style.setFontname(font.getName());
        style.setFontsize(font.getSize());
        style.setAlignment(config.getAlignment());
        style.setPrimaryColour(ColorUtils.hexToBGR(font.getColor()));
        style.setOutlineColor(ColorUtils.hexToBGR(font.getOutlineColor()));
        style.setOutline(font.getOutlineWidth());
        style.setMarginV(config.getVerticalMargin());
        return style;
    }

    public static String toSRTString(String textLine) {
        String formatted = textLine.replaceAll(ASS_ITALIC_OPEN, SRT_ITALIC_OPEN);
        formatted = formatted.replaceAll(ASS_ITALIC_CLOSE, SRT_ITALIC_CLOSE);
        formatted = formatted.replaceAll(RGX_ASS_FORMATTING, "");
        return formatted;
    }

    public static String toASSString(String textLine) {
        String formatted = textLine.replaceAll(SRT_ITALIC_OPEN, ASS_ITALIC_OPEN);
        formatted = formatted.replaceAll(SRT_ITALIC_CLOSE, ASS_ITALIC_CLOSE);
        return formatted.replaceAll(RGX_XML_TAG, "");
    }
}

