/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnbn.submerge.api.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mozilla.universalchardet.UniversalDetector;

public class FileUtils {
    public static String guessEncoding(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = FileUtils.guessEncoding(is);
            return string;
        }
    }

    public static String guessEncoding(InputStream is) throws IOException {
        return FileUtils.guessEncoding(IOUtils.toByteArray((InputStream)is));
    }

    public static String guessEncoding(byte[] bytes) {
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        if (encoding == null || "MACCYRILLIC".equals(encoding)) {
            CharsetMatch detected = new CharsetDetector().setText(bytes).detect();
            encoding = detected != null ? detected.getName() : "UTF-8";
        }
        return encoding;
    }
}

