/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.jdbc.snapshot.dao;

import akka.persistence.SnapshotMetadata;
import akka.persistence.jdbc.config.SnapshotConfig;
import akka.persistence.jdbc.snapshot.dao.ByteArraySnapshotSerializer;
import akka.persistence.jdbc.snapshot.dao.SnapshotDao;
import akka.persistence.jdbc.snapshot.dao.SnapshotQueries;
import akka.persistence.jdbc.snapshot.dao.SnapshotTables;
import akka.serialization.Serialization;
import akka.stream.Materializer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Y\u0005A!A!\u0002\u0017a\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I1A*\t\u0011i\u0003!\u0011!Q\u0001\nQCQa\u0017\u0001\u0005\u0002qCq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\u0001\b\u0001)A\u0005[\")\u0011\u000f\u0001C\u0001e\"9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003C\u0003A\u0011IAR\u0005Q\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e\u001e#b_*\u0011!dG\u0001\u0004I\u0006|'B\u0001\u000f\u001e\u0003!\u0019h.\u00199tQ>$(B\u0001\u0010 \u0003\u0011QGMY2\u000b\u0005\u0001\n\u0013a\u00039feNL7\u000f^3oG\u0016T\u0011AI\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011!G\u0005\u0003]e\u00111b\u00158baNDw\u000e\u001e#b_\u0006\u0011AM\u0019\t\u0003ca\u0002\"A\r\u001c\u000e\u0003MR!A\b\u001b\u000b\u0003U\nQa\u001d7jG.L!aN\u001a\u0003\u0017)#'m\u0019\"bG.,g\u000eZ\u0005\u0003sY\u00121\u0002R1uC\n\f7/\u001a#fM\u00069\u0001O]8gS2,\u0007C\u0001\u001a=\u0013\ti4GA\u0006KI\n\u001c\u0007K]8gS2,\u0017AD:oCB\u001c\bn\u001c;D_:4\u0017n\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005v\taaY8oM&<\u0017B\u0001#B\u00059\u0019f.\u00199tQ>$8i\u001c8gS\u001e\fQb]3sS\u0006d\u0017N_1uS>t\u0007CA$J\u001b\u0005A%BA#\"\u0013\tQ\u0005JA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u0003K\u000e\u0004\"!\u0014)\u000e\u00039S!aT\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002R\u001d\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004[\u0006$X#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]\u000b\u0013AB:ue\u0016\fW.\u0003\u0002Z-\naQ*\u0019;fe&\fG.\u001b>fe\u0006!Q.\u0019;!\u0003\u0019a\u0014N\\5u}Q)Q,\u00192dIR\u0019al\u00181\u0011\u00051\u0002\u0001\"B&\t\u0001\ba\u0005\"\u0002*\t\u0001\b!\u0006\"B\u0018\t\u0001\u0004\u0001\u0004\"\u0002\u001e\t\u0001\u0004Y\u0004\"\u0002 \t\u0001\u0004y\u0004\"B#\t\u0001\u00041\u0015aB9vKJLWm]\u000b\u0002OB\u0011A\u0006[\u0005\u0003Sf\u0011qb\u00158baNDw\u000e^)vKJLWm]\u0001\tcV,'/[3tA\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u00035\u0004\"\u0001\f8\n\u0005=L\"a\u0007\"zi\u0016\f%O]1z':\f\u0007o\u001d5piN+'/[1mSj,'/A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013A\u0004;p':\f\u0007o\u001d5pi\u0012\u000bG/\u0019\u000b\u0003gv\u0004BA\n;wu&\u0011Qo\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005]DX\"A\u0010\n\u0005e|\"\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b!\t130\u0003\u0002}O\t\u0019\u0011I\\=\t\u000byl\u0001\u0019A@\u0002\u0007I|w\u000f\u0005\u0003\u0002\u0002\u0005\u0005b\u0002BA\u0002\u0003;qA!!\u0002\u0002\u001c9!\u0011qAA\r\u001d\u0011\tI!a\u0006\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u0004\u0003?I\u0012AD*oCB\u001c\bn\u001c;UC\ndWm]\u0005\u0005\u0003G\t)CA\u0006T]\u0006\u00048\u000f[8u%><(bAA\u00103\u0005qA.\u0019;fgR\u001cf.\u00199tQ>$H\u0003BA\u0016\u0003o\u0001R!TA\u0017\u0003cI1!a\fO\u0005\u00191U\u000f^;sKB!a%a\rt\u0013\r\t)d\n\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005eb\u00021\u0001\u0002<\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!!\u0010\u0002F9!\u0011qHA!!\r\tiaJ\u0005\u0004\u0003\u0007:\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002D\u001d\nqc\u001d8baNDw\u000e\u001e$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005-\u0012qJA)\u0011\u001d\tId\u0004a\u0001\u0003wAq!a\u0015\u0010\u0001\u0004\t)&\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000fE\u0002'\u0003/J1!!\u0017(\u0005\u0011auN\\4\u00021Mt\u0017\r]:i_R4uN]'bqN+\u0017/^3oG\u0016t%\u000f\u0006\u0004\u0002,\u0005}\u0013\u0011\r\u0005\b\u0003s\u0001\u0002\u0019AA\u001e\u0011\u001d\t\u0019\u0007\u0005a\u0001\u0003+\nQ\"\\1y'\u0016\fX/\u001a8dK:\u0013\u0018aJ:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\u000b\u0002j\u0005-\u0014Q\u000e\u0005\b\u0003s\t\u0002\u0019AA\u001e\u0011\u001d\t\u0019'\u0005a\u0001\u0003+Bq!a\u0015\u0012\u0001\u0004\t)&\u0001\u0003tCZ,GCBA:\u0003w\ny\bE\u0003N\u0003[\t)\bE\u0002'\u0003oJ1!!\u001f(\u0005\u0011)f.\u001b;\t\r\u0005u$\u00031\u0001w\u0003A\u0019h.\u00199tQ>$X*\u001a;bI\u0006$\u0018\rC\u0003\u001d%\u0001\u0007!0\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003g\n))a\"\t\u000f\u0005e2\u00031\u0001\u0002<!9\u0011\u0011R\nA\u0002\u0005U\u0013AC:fcV,gnY3Oe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\t\u0019(a$\t\u000f\u0005eB\u00031\u0001\u0002<\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003g\n)*a&\t\u000f\u0005eR\u00031\u0001\u0002<!9\u00111M\u000bA\u0002\u0005U\u0013A\u00063fY\u0016$X-\u00169U_6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005M\u0014QTAP\u0011\u001d\tID\u0006a\u0001\u0003wAq!a\u0015\u0017\u0001\u0004\t)&\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\u001d\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003s9\u0002\u0019AA\u001e\u0011\u001d\t\u0019g\u0006a\u0001\u0003+Bq!a\u0015\u0018\u0001\u0004\t)\u0006")
public class ByteArraySnapshotDao
implements SnapshotDao {
    private final JdbcBackend.DatabaseDef db;
    private final JdbcProfile profile;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;
    private final ByteArraySnapshotSerializer serializer;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    public ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Tuple2<SnapshotMetadata, Object> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Tuple2 deserialized;
        Try<Tuple2<SnapshotMetadata, Object>> try_ = this.serializer().deserialize(row);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                throw cause;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        Tuple2 tuple2 = deserialized = (Tuple2)success.value();
        return tuple2;
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).map((Function1 & Serializable & scala.Serializable)rows -> rows.headOption().map((Function1 & Serializable & scala.Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable & scala.Serializable)rows -> rows.headOption().map((Function1 & Serializable & scala.Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable & scala.Serializable)rows -> rows.headOption().map((Function1 & Serializable & scala.Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable & scala.Serializable)rows -> rows.headOption().map((Function1 & Serializable & scala.Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        Future eventualSnapshotRow = Future$.MODULE$.fromTry(this.serializer().serialize(snapshotMetadata, snapshot));
        return eventualSnapshotRow.map((Function1 & Serializable & scala.Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable & scala.Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {}, this.ec);
    }

    public ByteArraySnapshotDao(JdbcBackend.DatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.snapshotTableConfiguration());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

