/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.encoder.GSCachedLayerEncoder;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWebCacheREST {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWebCacheREST.class);
    private final String restURL;
    private final String gsuser;
    private final String gspass;

    public GeoWebCacheREST(URL restURL, String username, String password) {
        this.restURL = HTTPUtils.decurtSlash(restURL.toString());
        this.gsuser = username;
        this.gspass = password;
    }

    public boolean configureLayer(GSCachedLayerEncoder layer) throws IllegalArgumentException {
        String layerXml;
        if (layer == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (layer.isEmpty()) {
            throw new IllegalArgumentException("Empty argument");
        }
        String layerName = layer.getName();
        if (layerName == null || layerName.isEmpty()) {
            throw new IllegalArgumentException("Missing layer name");
        }
        String url = this.restURL + "/gwc/rest/layers/" + HTTPUtils.enc(layerName) + ".xml";
        String sendResult = HTTPUtils.putXml(url, layerXml = layer.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Cached layer successfully configured: " + layerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring cached layer " + layerName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public boolean updateLayer(GSCachedLayerEncoder layer) throws IllegalArgumentException {
        String layerXml;
        if (layer == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (layer.isEmpty()) {
            throw new IllegalArgumentException("Empty argument");
        }
        String layerName = layer.getName();
        if (layerName == null || layerName.isEmpty()) {
            throw new IllegalArgumentException("Missing layer name");
        }
        String url = this.restURL + "/gwc/rest/layers/" + HTTPUtils.enc(layerName) + ".xml";
        String sendResult = HTTPUtils.postXml(url, layerXml = layer.toString(), this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Cached layer successfully configured: " + layerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error configuring cached layer " + layerName + " (" + sendResult + ")");
        }
        return sendResult != null;
    }

    public GSCachedLayerEncoder getLayer(String layerName) {
        if (layerName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (layerName.isEmpty()) {
            throw new IllegalArgumentException("Empty argument");
        }
        String url = this.restURL + "/gwc/rest/layers/" + HTTPUtils.enc(layerName) + ".xml";
        return GSCachedLayerEncoder.build(HTTPUtils.get(url, this.gsuser, this.gspass));
    }

    public boolean deleteLayer(String layerName) {
        if (layerName == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (layerName.isEmpty()) {
            throw new IllegalArgumentException("Empty argument");
        }
        String url = this.restURL + "/gwc/rest/layers/" + HTTPUtils.enc(layerName) + ".xml";
        boolean sendResult = HTTPUtils.delete(url, this.gsuser, this.gspass);
        if (sendResult) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Successfully deleted cached layer: " + layerName);
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error deleting cached layer " + layerName);
        }
        return sendResult;
    }

    public boolean truncateLayer(String layerName) {
        String xml;
        String url = this.restURL + "/gwc/rest/masstruncate";
        String sendResult = HTTPUtils.postXml(url, xml = "<truncateLayer><layerName>" + layerName + "</layerName></truncateLayer>", this.gsuser, this.gspass);
        if (sendResult != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Successfully mass truncated layer: " + layerName);
            }
            return true;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error mass truncating layer " + layerName + " (" + sendResult + ")");
        }
        return false;
    }
}

