/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTSecurityManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;

public class RESTDataRules {
    private static String RESOURCE = "resource";
    private final Element rulesElem;

    public static RESTDataRules build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTDataRules(pb);
        }
        return null;
    }

    public RESTDataRules(Element elem) {
        this.rulesElem = elem;
    }

    public Set<String> getRule(String workspace, String layer, GeoServerRESTSecurityManager.RuleType type) {
        String ruleResource = GeoServerRESTSecurityManager.resource(workspace, layer, type);
        for (Object o : this.rulesElem.getChildren()) {
            Element child = (Element)o;
            if (!ruleResource.equals(child.getAttributeValue("resource"))) continue;
            if ("*".equals(child.getText())) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(child.getText().split(",")));
        }
        return null;
    }
}

