/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTLayer;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.authorityurl.GSAuthorityURLInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.identifier.GSIdentifierInfoEncoder;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class RESTLayer21
extends RESTLayer {
    public RESTLayer21(Element layerElem) {
        super(layerElem);
    }

    public static RESTLayer21 build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTLayer21(pb);
        }
        return null;
    }

    @Override
    public boolean getAdvertised() {
        List metaElements;
        boolean advertised = true;
        Element metadataRoot = this.layerElem.getChild("metadata");
        if (metadataRoot != null && (metaElements = metadataRoot.getChildren()) != null) {
            for (Element el : metaElements) {
                String key = el.getAttributeValue("key");
                if (!key.matches("advertised")) continue;
                advertised = Boolean.parseBoolean(el.getValue());
            }
        }
        return advertised;
    }

    @Override
    public List<GSAuthorityURLInfoEncoder> getEncodedAuthorityURLInfoList() {
        List metaElements;
        ArrayList<GSAuthorityURLInfoEncoder> authorityURLList = null;
        Element metadataRoot = this.layerElem.getChild("metadata");
        if (metadataRoot != null && (metaElements = metadataRoot.getChildren()) != null) {
            for (Element element : metaElements) {
                String key = element.getAttributeValue("key");
                if (!key.matches("authorityURLs")) continue;
                String jsonStr = element.getValue();
                jsonStr = jsonStr.substring(2);
                jsonStr = jsonStr.substring(0, jsonStr.length() - 3);
                String[] items = jsonStr.split("\\}(,)\\{");
                authorityURLList = new ArrayList<GSAuthorityURLInfoEncoder>(items.length);
                for (String item : items) {
                    String[] props = item.split(",");
                    String[] kvp1 = props[0].split("\":");
                    String name = kvp1[1].replace("\"", "");
                    String[] kvp2 = props[1].split("\":");
                    String href = kvp2[1].replace("\"", "");
                    authorityURLList.add(new GSAuthorityURLInfoEncoder(name, href));
                }
            }
        }
        return authorityURLList;
    }

    @Override
    public List<GSIdentifierInfoEncoder> getEncodedIdentifierInfoList() {
        List metaElements;
        ArrayList<GSIdentifierInfoEncoder> identifierList = null;
        Element metadataRoot = this.layerElem.getChild("metadata");
        if (metadataRoot != null && (metaElements = metadataRoot.getChildren()) != null) {
            for (Element element : metaElements) {
                String key = element.getAttributeValue("key");
                if (!key.matches("identifiers")) continue;
                String jsonStr = element.getValue();
                jsonStr = jsonStr.substring(2);
                jsonStr = jsonStr.substring(0, jsonStr.length() - 3);
                String[] items = jsonStr.split("\\}(,)\\{");
                identifierList = new ArrayList<GSIdentifierInfoEncoder>(items.length);
                for (String item : items) {
                    String[] props = item.split(",");
                    String[] kvp1 = props[0].split("\":");
                    String authority = kvp1[1].replace("\"", "");
                    String[] kvp2 = props[1].split("\":");
                    String identifier = kvp2[1].replace("\"", "");
                    identifierList.add(new GSIdentifierInfoEncoder(authority, identifier));
                }
            }
        }
        return identifierList;
    }
}

