/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RESTMetadataList
implements Iterable<RESTMetadataElement> {
    private final List<Element> metadataList;

    protected RESTMetadataList(Element list) {
        ArrayList<Element> tmpList = new ArrayList<Element>();
        for (Element el : list.getChildren("entry")) {
            tmpList.add(el);
        }
        this.metadataList = Collections.unmodifiableList(tmpList);
    }

    public int size() {
        return this.metadataList.size();
    }

    public boolean isEmpty() {
        return this.metadataList.isEmpty();
    }

    public RESTMetadataElement get(int index) {
        return new RESTMetadataElement(this.metadataList.get(index));
    }

    @Override
    public Iterator<RESTMetadataElement> iterator() {
        return new RESTMetadataIterator(this.metadataList);
    }

    public static class RESTMetadataElement {
        protected final Element metadataElem;

        public RESTMetadataElement(Element elem) {
            this.metadataElem = elem;
        }

        public String getKey() {
            return this.metadataElem.getAttributeValue("key");
        }

        public Element getMetadataElem() {
            return this.metadataElem;
        }
    }

    private static class RESTMetadataIterator
    implements Iterator<RESTMetadataElement> {
        private final Iterator<Element> iter;

        public RESTMetadataIterator(List<Element> orig) {
            this.iter = orig.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RESTMetadataElement next() {
            return new RESTMetadataElement(this.iter.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

