/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Element;

public abstract class GSAbstractStoreEncoder
extends PropertyXMLEncoder {
    private final GeoServerRESTPublisher.StoreType type;

    protected GSAbstractStoreEncoder(GeoServerRESTPublisher.StoreType type, String storeName) {
        super(type.getType());
        this.type = type;
    }

    public GeoServerRESTPublisher.StoreType getStoreType() {
        return this.type;
    }

    public void setType(String type) {
        this.set("type", type);
    }

    public String getType() {
        return ElementUtils.contains(this.getRoot(), "type").getTextTrim();
    }

    public void setName(String name) {
        this.ensureValidName(name);
        this.set("name", name);
    }

    public String getName() {
        Element e = ElementUtils.contains(this.getRoot(), "name");
        return e != null ? e.getTextTrim() : null;
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        Element e = ElementUtils.contains(this.getRoot(), "description");
        return e != null ? e.getTextTrim() : null;
    }

    public void setEnabled(boolean enabled) {
        this.set("enabled", Boolean.toString(enabled));
    }

    public boolean getEnabled() {
        Element e = ElementUtils.contains(this.getRoot(), "name");
        if (e != null) {
            return Boolean.parseBoolean(e.getTextTrim());
        }
        return false;
    }

    protected void ensureValidName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Store name cannot be null or empty");
        }
    }

    protected void ensureValidType(String type) {
        if (!type.equals(this.getValidType())) {
            throw new IllegalArgumentException("The store type '" + type + "' is not valid");
        }
    }

    protected abstract String getValidType();
}

