/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Element;

public class GSBackupEncoder
extends PropertyXMLEncoder {
    public static final String TASK = "task";
    public static final String PATH = "path";
    public static final String INCLUDE_DATA = "includedata";
    public static final String INCLUDE_GWC = "includegwc";
    public static final String INCLUDE_LOG = "includelog";

    public GSBackupEncoder() {
        super(TASK);
    }

    public GSBackupEncoder(String name) {
        super(TASK);
        this.addPath(name);
    }

    public void addPath(String path) {
        Element el = ElementUtils.contains(this.getRoot(), PATH);
        if (el != null) {
            throw new IllegalStateException("Task path is already set: " + el.getText());
        }
        this.add(PATH, path);
    }

    public void setPath(String path) {
        Element el = ElementUtils.contains(this.getRoot(), PATH);
        if (el == null) {
            this.add(PATH, path);
        } else {
            el.setText(path);
        }
    }

    public String getPath() {
        Element el = ElementUtils.contains(this.getRoot(), PATH);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public void addIncludeData(Boolean includedata) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_DATA);
        if (el == null) {
            this.add(INCLUDE_DATA, includedata.toString());
        } else {
            el.setText(includedata.toString());
        }
    }

    public void setIncludeData(Boolean includedata) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_DATA);
        if (el == null) {
            this.add(INCLUDE_DATA, includedata.toString());
        } else {
            el.setText(includedata.toString());
        }
    }

    public String getIncludeData() {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_DATA);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public void addIncludeGwc(Boolean includegwc) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_GWC);
        if (el == null) {
            this.add(INCLUDE_GWC, includegwc.toString());
        } else {
            el.setText(includegwc.toString());
        }
    }

    public void setIncludeGwc(Boolean includegwc) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_GWC);
        if (el == null) {
            this.add(INCLUDE_GWC, includegwc.toString());
        } else {
            el.setText(includegwc.toString());
        }
    }

    public String getIncludeGwc() {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_GWC);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public void addIncludeLog(Boolean includelog) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_LOG);
        if (el == null) {
            this.add(INCLUDE_LOG, includelog.toString());
        } else {
            el.setText(includelog.toString());
        }
    }

    public void setIncludeLog(Boolean includelog) {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_LOG);
        if (el == null) {
            this.add(INCLUDE_LOG, includelog.toString());
        } else {
            el.setText(includelog.toString());
        }
    }

    public String getIncludeLog() {
        Element el = ElementUtils.contains(this.getRoot(), INCLUDE_LOG);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }
}

