/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Content;
import org.jdom.Element;

public class GSCachedLayerEncoder
extends PropertyXMLEncoder {
    public static final String MIME_FORMATS = "mimeFormats";
    public static final String GRIDSUBSETS = "gridSubsets";
    public static final String PARAMETER_FILTERS = "parameterFilters";
    private final Element mimeFormatsListEncoder;
    private final Element gridSubsetsListEncoder;
    private final Element parameterFiltersListEncoder;

    private GSCachedLayerEncoder(Element root) {
        super(root);
        this.mimeFormatsListEncoder = root.getChild(MIME_FORMATS);
        this.gridSubsetsListEncoder = root.getChild(GRIDSUBSETS);
        this.parameterFiltersListEncoder = root.getChild(PARAMETER_FILTERS);
    }

    public static GSCachedLayerEncoder build(String response) {
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new GSCachedLayerEncoder(pb);
        }
        return null;
    }

    public GSCachedLayerEncoder() {
        this(true);
    }

    public GSCachedLayerEncoder(boolean encodeLists) {
        super("GeoServerLayer");
        this.setEnabled(true);
        this.mimeFormatsListEncoder = new Element(MIME_FORMATS);
        this.gridSubsetsListEncoder = new Element(GRIDSUBSETS);
        this.parameterFiltersListEncoder = new Element(PARAMETER_FILTERS);
        if (encodeLists) {
            this.addContent((Content)this.mimeFormatsListEncoder);
            this.addContent((Content)this.gridSubsetsListEncoder);
            this.addContent((Content)this.parameterFiltersListEncoder);
        }
    }

    void encodeMimeFormats(boolean encoded) {
        if (encoded) {
            if (this.get(this.mimeFormatsListEncoder.getName()) == null) {
                this.addContent((Content)this.mimeFormatsListEncoder);
            }
        } else {
            this.remove(this.mimeFormatsListEncoder.getName());
        }
    }

    void encodeGridSubsets(boolean encoded) {
        if (encoded) {
            if (this.get(this.gridSubsetsListEncoder.getName()) == null) {
                this.addContent((Content)this.gridSubsetsListEncoder);
            }
        } else {
            this.remove(this.gridSubsetsListEncoder.getName());
        }
    }

    void encodeParameterFilters(boolean encoded) {
        if (encoded) {
            if (this.get(this.parameterFiltersListEncoder.getName()) == null) {
                this.addContent((Content)this.parameterFiltersListEncoder);
            }
        } else {
            this.remove(this.parameterFiltersListEncoder.getName());
        }
    }

    public void setId(String id) {
        this.set("id", id);
    }

    public String getId() {
        Element node = this.get("id");
        return node != null ? node.getText() : null;
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.set("enabled", "true");
        } else {
            this.set("enabled", "false");
        }
    }

    public boolean isEnabled() {
        Element node = this.get("enabled");
        return node != null ? Boolean.valueOf(Boolean.parseBoolean(node.getText())) : null;
    }

    public void setInMemoryCached(boolean enable) {
        if (enable) {
            this.set("inMemoryCached", "true");
        } else {
            this.set("inMemoryCached", "false");
        }
    }

    public boolean isInMemoryCached() {
        Element node = this.get("inMemoryCached");
        return node != null ? Boolean.valueOf(Boolean.parseBoolean(node.getText())) : null;
    }

    public void setBlobStoreId(String blobStoreId) {
        this.set("blobStoreId", blobStoreId);
    }

    public String getBlobStoreId() {
        Element node = this.get("blobStoreId");
        return node != null ? node.getText() : null;
    }

    public void setExpireCache(int expireCache) {
        this.set("expireCache", Integer.toString(expireCache));
    }

    public int getExpireCache() {
        Element node = this.get("expireCache");
        return node != null ? Integer.valueOf(Integer.parseInt(node.getText())) : null;
    }

    public void setExpireClients(int expireClients) {
        this.set("expireClients", Integer.toString(expireClients));
    }

    public int getExpireClients() {
        Element node = this.get("expireClients");
        return node != null ? Integer.valueOf(Integer.parseInt(node.getText())) : null;
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        Element node = this.get("name");
        return node != null ? node.getText() : null;
    }

    public void setGutter(int gutter) {
        this.set("gutter", Integer.toString(gutter));
    }

    public int getGutter() {
        Element node = this.get("gutter");
        return node != null ? Integer.valueOf(Integer.parseInt(node.getText())) : null;
    }

    public void setMetaWidthHeight(int ... values) {
        Element el = new Element("metaWidthHeight");
        for (int value : values) {
            Element elChild = new Element("int");
            elChild.setText(Integer.toString(value));
            el.addContent((Content)elChild);
        }
        Element pp = ElementUtils.contains(this.getRoot(), "metaWidthHeight");
        if (pp != null) {
            ElementUtils.remove(pp, pp);
        }
        this.addContent((Content)el);
    }

    public void addMimeFormat(String mimeFormat) {
        Element el = new Element("string");
        el.setText(mimeFormat);
        this.mimeFormatsListEncoder.addContent((Content)el);
    }

    public void addParameterFilter(String type, String key, String defaultValue) {
        Element el = new Element(type);
        Element elKey = new Element("key");
        elKey.setText(key);
        el.addContent((Content)elKey);
        Element elDefaultValue = new Element("defaultValue");
        elDefaultValue.setText(defaultValue);
        el.addContent((Content)elDefaultValue);
        this.parameterFiltersListEncoder.addContent((Content)el);
    }

    public void addGridSubset(String gridSetName, Integer zoomStart, Integer zoomStop, Integer minCachedLevel, Integer maxCachedLevel) {
        Element el = new Element("gridSubset");
        Element elName = new Element("gridSetName");
        elName.setText(gridSetName);
        el.addContent((Content)elName);
        if (zoomStart != null) {
            Element elZoomStart = new Element("zoomStart");
            elZoomStart.setText(zoomStart.toString());
            el.addContent((Content)elZoomStart);
        }
        if (zoomStop != null) {
            Element elZoomStop = new Element("zoomStop");
            elZoomStop.setText(zoomStop.toString());
            el.addContent((Content)elZoomStop);
        }
        if (minCachedLevel != null) {
            Element elMin = new Element("minCachedLevel");
            elMin.setText(minCachedLevel.toString());
            el.addContent((Content)elMin);
        }
        if (maxCachedLevel != null) {
            Element elMax = new Element("maxCachedLevel");
            elMax.setText(maxCachedLevel.toString());
            el.addContent((Content)elMax);
        }
        this.gridSubsetsListEncoder.addContent((Content)el);
    }

    public String getGridSubsetName(int index) {
        return ((Element)this.gridSubsetsListEncoder.getChildren().get(index)).getChildText("gridSetName").trim();
    }

    public Integer getGridSubsetZoomStart(int index) {
        String s = ((Element)this.gridSubsetsListEncoder.getChildren().get(index)).getChildText("zoomStart");
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public Integer getGridSubsetZoomStop(int index) {
        String s = ((Element)this.gridSubsetsListEncoder.getChildren().get(index)).getChildText("zoomStop");
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public Integer getGridSubsetMinCachedLevel(int index) {
        String s = ((Element)this.gridSubsetsListEncoder.getChildren().get(index)).getChildText("minCachedLevel");
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public Integer getGridSubsetMaxCachedLevel(int index) {
        String s = ((Element)this.gridSubsetsListEncoder.getChildren().get(index)).getChildText("maxCachedLevel");
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    public String getMimeFormat(int index) {
        return ((Element)this.mimeFormatsListEncoder.getChildren().get(index)).getValue().trim();
    }

    public String getParameterFilterKey(int index) {
        return ((Element)this.parameterFiltersListEncoder.getChildren().get(index)).getChildText("key").trim();
    }

    public String getParameterFilterDefaultValue(int index) {
        return ((Element)this.parameterFiltersListEncoder.getChildren().get(index)).getChildText("defaultValue").trim();
    }

    public String getParameterFilterType(int index) {
        return ((Element)this.parameterFiltersListEncoder.getChildren().get(index)).getName();
    }
}

