/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import org.jdom.Content;
import org.jdom.Element;

public class GSStyleEncoder
extends PropertyXMLEncoder {
    public static final String STYLE = "style";
    public static final String NAME = "name";

    public GSStyleEncoder() {
        super(STYLE);
    }

    public GSStyleEncoder(String name) {
        super(STYLE);
        this.addName(name);
    }

    protected void addName(String name) {
        Element el = ElementUtils.contains(this.getRoot(), NAME);
        if (el != null) {
            throw new IllegalStateException("Workspace name is already set: " + el.getText());
        }
        this.add(NAME, name);
    }

    public void setName(String name) {
        Element el = ElementUtils.contains(this.getRoot(), NAME);
        if (el == null) {
            this.add(NAME, name);
        } else {
            el.setText(name);
        }
    }

    public String getName() {
        Element el = ElementUtils.contains(this.getRoot(), NAME);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public void setLegendGraphic(String onlineResource, String format, int width, int height) {
        Element legend = new Element("legend");
        Element elOnlineResource = new Element("onlineResource");
        elOnlineResource.setText(onlineResource);
        Element elFormat = new Element("format");
        elFormat.setText(format);
        Element elWidth = new Element("width");
        elWidth.setText("" + width);
        Element elHeight = new Element("height");
        elHeight.setText("" + height);
        legend.addContent((Content)elOnlineResource);
        legend.addContent((Content)elFormat);
        legend.addContent((Content)elWidth);
        legend.addContent((Content)elHeight);
        this.addContent((Content)legend);
    }

    public void setFormat(String format) {
        Element elFormat = new Element("format");
        elFormat.setText(format);
        this.addContent((Content)elFormat);
    }

    public void setLanguageVersion(String version) {
        Element elLanguageVersion = new Element("languageVersion");
        Element elVersion = new Element("version");
        elVersion.setText(version);
        elLanguageVersion.addContent((Content)elVersion);
        this.addContent((Content)elLanguageVersion);
    }
}

