/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.authorityurl;

import it.geosolutions.geoserver.rest.encoder.authorityurl.AuthorityURLInfo;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSAuthorityURLInfoEncoder
extends XmlElement {
    public static Filter getFilterByHref(String href) {
        return new filterByHref(href);
    }

    public GSAuthorityURLInfoEncoder() {
        super("AuthorityURL");
    }

    public GSAuthorityURLInfoEncoder(String name, String href) {
        super("AuthorityURL");
        this.setup(name, href);
    }

    protected void setup(String name, String href) {
        this.set(AuthorityURLInfo.name.name(), name);
        this.set(AuthorityURLInfo.href.name(), href);
    }

    protected void setMember(AuthorityURLInfo type, String value) {
        this.set(type.toString(), value);
    }

    public void setName(String name) {
        this.setMember(AuthorityURLInfo.name, name);
    }

    public void setHref(String href) {
        this.setMember(AuthorityURLInfo.href, href);
    }

    protected boolean delMember(AuthorityURLInfo type) {
        return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(type.toString()));
    }

    public boolean delName() {
        return this.delMember(AuthorityURLInfo.name);
    }

    public boolean delHref() {
        return this.delMember(AuthorityURLInfo.href);
    }

    protected String getMember(AuthorityURLInfo type) {
        Element el = this.getRoot().getChild(type.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public String getName() {
        return this.getMember(AuthorityURLInfo.name);
    }

    public String getHref() {
        return this.getMember(AuthorityURLInfo.href);
    }

    private static class filterByHref
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByHref(String href) {
            this.key = href;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild(AuthorityURLInfo.href.toString());
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

