/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.feature;

import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.FeatureTypeAttribute;
import it.geosolutions.geoserver.rest.encoder.feature.GSAttributeEncoder;
import it.geosolutions.geoserver.rest.encoder.metadata.GSFeatureDimensionInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.metadata.virtualtable.GSVirtualTableEncoder;
import org.jdom.Content;
import org.jdom.Element;

public class GSFeatureTypeEncoder
extends GSResourceEncoder {
    public static final String ATTRIBUTES = "attributes";
    private final Element attributes = new Element("attributes");

    public GSFeatureTypeEncoder() {
        this(true);
    }

    public GSFeatureTypeEncoder(boolean encodeLists) {
        super("featureType", encodeLists);
        if (encodeLists) {
            this.addContent((Content)this.attributes);
        }
    }

    void encodeAttributes(boolean encoded) {
        if (encoded) {
            if (this.get(this.attributes.getName()) == null) {
                this.addContent((Content)this.attributes);
            }
        } else {
            this.remove(this.attributes.getName());
        }
    }

    protected void addMetadata(String key, GSFeatureDimensionInfoEncoder dimensionInfo) {
        super.addMetadata(key, dimensionInfo);
    }

    public void setMetadata(String key, GSFeatureDimensionInfoEncoder dimensionInfo) {
        super.setMetadata(key, dimensionInfo);
    }

    protected void addMetadataVirtualTable(GSVirtualTableEncoder virtualtable) {
        super.addMetadata("JDBC_VIRTUAL_TABLE", virtualtable);
    }

    public void setMetadataVirtualTable(GSVirtualTableEncoder virtualtable) {
        super.setMetadata("JDBC_VIRTUAL_TABLE", virtualtable);
    }

    public boolean delMetadataVirtualTable() {
        return super.delMetadata("JDB_VIRTUAL_TABLE");
    }

    public boolean delAttribute(String keyword) {
        Element el = new Element("string");
        el.setText(keyword);
        return this.attributes.removeContent(GSAttributeEncoder.getFilterByName(keyword)).size() != 0;
    }

    protected void addAttribute(GSAttributeEncoder attribute) {
        this.attributes.addContent((Content)attribute.getRoot());
    }

    public void setAttribute(GSAttributeEncoder attribute) {
        this.delAttribute(attribute.getAttribute(FeatureTypeAttribute.name));
        this.addAttribute(attribute);
    }
}

