/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadata;

import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import java.math.BigDecimal;

public class GSDimensionInfoEncoder
extends XmlElement {
    public static final String DIMENSIONINFO = "dimensionInfo";
    public static final String RESOLUTION = "resolution";
    public static final String PRESENTATION = "presentation";
    public static final String UNITS = "units";
    public static final String UNIT_SYMBOL = "unitSymbol";
    private boolean enabled;

    public GSDimensionInfoEncoder(boolean enabled) {
        super(DIMENSIONINFO);
        this.add("enabled", enabled ? "true" : "false");
        this.enabled = enabled;
    }

    public GSDimensionInfoEncoder() {
        super(DIMENSIONINFO);
        this.add("enabled", "false");
        this.enabled = Boolean.FALSE;
    }

    public void setEnabled(boolean enabled) {
        this.set("enabled", "true");
        this.enabled = Boolean.TRUE;
    }

    public void setPresentation(Presentation pres) {
        this.setPresentation(pres, null);
    }

    protected void addPresentation(Presentation pres, BigDecimal interval) {
        if (this.enabled) {
            this.add(PRESENTATION, pres.toString());
            if (pres == Presentation.DISCRETE_INTERVAL) {
                if (pres == Presentation.DISCRETE_INTERVAL && interval == null) {
                    throw new IllegalArgumentException("Null interval was provided while trying to set the presentation to discrete interval.");
                }
                this.add(RESOLUTION, String.valueOf(interval));
            } else {
                this.remove(RESOLUTION);
            }
        }
    }

    public void setPresentation(Presentation pres, BigDecimal interval) {
        if (this.enabled) {
            this.set(PRESENTATION, pres.toString());
            if (pres == Presentation.DISCRETE_INTERVAL) {
                if (pres == Presentation.DISCRETE_INTERVAL && interval == null) {
                    throw new IllegalArgumentException("Null interval was provided while trying to set the presentation to discrete interval.");
                }
                this.set(RESOLUTION, String.valueOf(interval));
            } else {
                this.remove(RESOLUTION);
            }
        }
    }

    public void setUnit(String unit) {
        if (unit == null || unit.length() <= 0) {
            return;
        }
        if (this.enabled) {
            this.set(UNITS, unit);
        }
    }

    public void setUnitSymbol(String unitSymbol) {
        if (unitSymbol == null || unitSymbol.length() <= 0) {
            return;
        }
        if (this.enabled) {
            this.set(UNIT_SYMBOL, unitSymbol);
        }
    }

    public static enum Presentation {
        LIST,
        CONTINUOUS_INTERVAL,
        DISCRETE_INTERVAL;

    }
}

