/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadata.virtualtable;

import it.geosolutions.geoserver.rest.encoder.metadata.virtualtable.VTGeometry;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class VTGeometryEncoder
extends XmlElement {
    public static Filter getFilterByName(String name) {
        return new filterByName(name);
    }

    public VTGeometryEncoder() {
        super("geometry");
    }

    public VTGeometryEncoder(String name, String geometryType, String srid) {
        super("geometry");
        this.setup(name, geometryType, srid);
    }

    protected void setup(String name, String geometryType, String srid) {
        this.setName(name);
        this.setType(geometryType);
        this.setSrid(srid);
    }

    protected void setMember(VTGeometry type, String value) {
        this.set(type.toString(), value);
    }

    public void setName(String name) {
        this.setMember(VTGeometry.name, name);
    }

    public void setType(String type) {
        this.setMember(VTGeometry.type, type);
    }

    public void setSrid(String srid) {
        this.setMember(VTGeometry.srid, srid);
    }

    protected boolean delMember(VTGeometry type) {
        return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(type.toString()));
    }

    public boolean delName() {
        return this.delMember(VTGeometry.name);
    }

    public boolean delType() {
        return this.delMember(VTGeometry.type);
    }

    public boolean delSrid() {
        return this.delMember(VTGeometry.srid);
    }

    protected String getMember(VTGeometry type) {
        Element el = this.getRoot().getChild(type.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public String getName() {
        return this.getMember(VTGeometry.name);
    }

    public String getType() {
        return this.getMember(VTGeometry.type);
    }

    public String getSrid() {
        return this.getMember(VTGeometry.srid);
    }

    private static class filterByName
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByName(String name) {
            this.key = name;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild(VTGeometry.name.toString());
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

