/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadatalink;

import it.geosolutions.geoserver.rest.encoder.metadatalink.ResourceMetadataLinkInfo;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSMetadataLinkInfoEncoder
extends XmlElement {
    public static Filter getFilterByContent(String content) {
        return new filterByContent(content);
    }

    public GSMetadataLinkInfoEncoder() {
        super("metadataLink");
    }

    public GSMetadataLinkInfoEncoder(String type, String metadataType, String content) {
        super("metadataLink");
        this.setup(type, metadataType, content);
    }

    protected void setup(String type, String metadataType, String content) {
        this.set(ResourceMetadataLinkInfo.type.name(), type);
        this.set(ResourceMetadataLinkInfo.metadataType.name(), metadataType);
        this.set(ResourceMetadataLinkInfo.content.name(), content);
    }

    protected void setMember(ResourceMetadataLinkInfo type, String value) {
        this.set(type.toString(), value);
    }

    public void setType(String type) {
        this.setMember(ResourceMetadataLinkInfo.type, type);
    }

    public void setMetadataType(String metadataType) {
        this.setMember(ResourceMetadataLinkInfo.metadataType, metadataType);
    }

    public void setContent(String content) {
        this.setMember(ResourceMetadataLinkInfo.content, content);
    }

    protected boolean delMember(ResourceMetadataLinkInfo type) {
        return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(type.toString()));
    }

    public boolean delType() {
        return this.delMember(ResourceMetadataLinkInfo.type);
    }

    public boolean delMetadataType() {
        return this.delMember(ResourceMetadataLinkInfo.metadataType);
    }

    public boolean delContent() {
        return this.delMember(ResourceMetadataLinkInfo.content);
    }

    protected String getMember(ResourceMetadataLinkInfo type) {
        Element el = this.getRoot().getChild(type.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public String getType() {
        return this.getMember(ResourceMetadataLinkInfo.type);
    }

    public String getMetadataType() {
        return this.getMember(ResourceMetadataLinkInfo.metadataType);
    }

    public String getContent() {
        return this.getMember(ResourceMetadataLinkInfo.content);
    }

    private static class filterByContent
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByContent(String content) {
            this.key = content;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild(ResourceMetadataLinkInfo.content.toString());
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

