/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerRESTImporterManager
extends GeoServerRESTAbstractManager {
    private static final String MEDIA_TYPE_APPLICATION_ZIP = "application/zip";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTImporterManager.class);

    public GeoServerRESTImporterManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    public JSONObject getImport(int imp) throws Exception {
        JSON json = HTTPUtils.getAsJSON(String.format(this.buildUrl() + "/%d", imp), this.gsuser, this.gspass);
        return ((JSONObject)json).getJSONObject("import");
    }

    public JSONObject getTask(int imp, int task) throws Exception {
        JSON json = HTTPUtils.getAsJSON(String.format(this.buildUrl() + "/%d/tasks/%d?expand=all", imp, task), this.gsuser, this.gspass);
        return ((JSONObject)json).getJSONObject("task");
    }

    public void putTask(int imp, int task, String json) throws Exception {
        HTTPUtils.put(String.format(this.buildUrl() + "/%d/tasks/%d", imp, task), json, "application/json", this.gsuser, this.gspass);
    }

    public void putTaskLayer(int imp, int task, String json) throws Exception {
        HTTPUtils.putJson(String.format(this.buildUrl() + "/%d/tasks/%d/layer", imp, task), json, this.gsuser, this.gspass);
    }

    public void postTaskTransform(int imp, int task, String json) throws Exception {
        HTTPUtils.postJson(String.format(this.buildUrl() + "/%d/tasks/%d/transforms", imp, task), json, this.gsuser, this.gspass);
    }

    public int postNewImport() throws Exception {
        return this.postNewImport(null);
    }

    public int postNewImport(String body) throws Exception {
        String resp = body == null ? HTTPUtils.post(this.buildUrl(), "", "application/json", this.gsuser, this.gspass) : HTTPUtils.postJson(this.buildUrl(), body, this.gsuser, this.gspass);
        JSONObject json = (JSONObject)HTTPUtils.json(resp);
        JSONObject imprt = json.getJSONObject("import");
        return imprt.getInt("id");
    }

    public void postImport(int imp) throws Exception {
        HTTPUtils.post(this.buildUrl() + "/" + imp + "?exec=true", "", "application/json", this.gsuser, this.gspass);
    }

    public int postNewTaskAsMultiPartForm(int imp, String data) throws Exception {
        String resp = HTTPUtils.postMultipartForm(this.buildUrl() + "/" + imp + "/tasks", GeoServerRESTImporterManager.unpack(data), this.gsuser, this.gspass);
        JSONObject json = (JSONObject)HTTPUtils.json(resp);
        JSONObject task = json.getJSONObject("task");
        return task.getInt("id");
    }

    public int putNewTask(int imp, String path) throws Exception {
        File zip = new File(path);
        String resp = HTTPUtils.put(this.buildUrl() + "/" + imp + "/tasks/" + zip.getName(), zip, MEDIA_TYPE_APPLICATION_ZIP, this.gsuser, this.gspass);
        JSONObject json = (JSONObject)HTTPUtils.json(resp);
        JSONObject task = json.getJSONObject("task");
        return task.getInt("id");
    }

    protected String buildUrl() {
        StringBuilder sUrl = new StringBuilder(this.gsBaseUrl.toString()).append("/rest/imports");
        return sUrl.toString();
    }

    public static File tmpDir() throws Exception {
        File dir = File.createTempFile("importer", "data", new File("target"));
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    public static File unpack(String path) throws Exception {
        return GeoServerRESTImporterManager.unpack(path, GeoServerRESTImporterManager.tmpDir());
    }

    public static File unpack(String path, File dir) throws Exception {
        File file = new File(path);
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            int len;
            String fileName = zipEntry.getName();
            File newFile = new File(dir, fileName);
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return dir;
    }
}

