/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.decoder.RESTDataRules;
import it.geosolutions.geoserver.rest.encoder.GSDataRulesEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.net.URL;

public class GeoServerRESTSecurityManager
extends GeoServerRESTAbstractManager {
    public static final String ANY = "*";
    private String SECURITY_PATH = "/rest/security";
    private String DATA_PATH = "/acl/layers";

    public static String resource(String workspace, String layer, RuleType type) {
        return workspace + "." + layer + "." + type.name().toLowerCase();
    }

    public GeoServerRESTSecurityManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    private String urlFromPath(String path) {
        return HTTPUtils.append(this.gsBaseUrl, this.SECURITY_PATH, path).toString();
    }

    private String urlFromPath(String path, String res) {
        return HTTPUtils.append(this.gsBaseUrl, this.SECURITY_PATH, path, "/", res).toString();
    }

    public RESTDataRules getDataRules() {
        return RESTDataRules.build(HTTPUtils.get(this.urlFromPath(this.DATA_PATH + ".xml"), this.gsuser, this.gspass));
    }

    public void addDataRules(GSDataRulesEncoder rules) {
        HTTPUtils.postXml(this.urlFromPath(this.DATA_PATH), rules.toString(), this.gsuser, this.gspass);
    }

    public void modifyDataRules(GSDataRulesEncoder rules) {
        HTTPUtils.putXml(this.urlFromPath(this.DATA_PATH), rules.toString(), this.gsuser, this.gspass);
    }

    public void deleteDataRule(String workspace, String layer, RuleType type) {
        HTTPUtils.delete(this.urlFromPath(this.DATA_PATH, GeoServerRESTSecurityManager.resource(workspace, layer, type)), this.gsuser, this.gspass);
    }

    public static enum RuleType {
        R,
        W,
        A;

    }
}

