/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.net.MalformedURLException;
import java.net.URL;

public class GeoServerRESTStoreManager
extends GeoServerRESTAbstractManager {
    public GeoServerRESTStoreManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    public boolean create(String workspace, GSAbstractStoreEncoder store) {
        String xml;
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", HTTPUtils.enc(workspace), "/", store.getStoreType().toString(), ".", GeoServerRESTPublisher.Format.XML.toString()).toString();
        String result = HTTPUtils.postXml(sUrl, xml = store.toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean update(String workspace, GSAbstractStoreEncoder store) {
        return this.update(workspace, store.getName(), store);
    }

    public boolean update(String workspace, String storeName, GSAbstractStoreEncoder store) {
        String xml;
        String sUrl = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", HTTPUtils.enc(workspace), "/", store.getStoreType().toString(), "/", HTTPUtils.enc(storeName), ".", GeoServerRESTPublisher.Format.XML.toString()).toString();
        String result = HTTPUtils.putXml(sUrl, xml = store.toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean remove(String workspace, GSAbstractStoreEncoder store, boolean recurse) throws IllegalArgumentException {
        URL deleteStore;
        StringBuilder url = HTTPUtils.append(this.gsBaseUrl, "/rest/workspaces/", HTTPUtils.enc(workspace), "/", store.getStoreType().toString(), "/", HTTPUtils.enc(store.getName()));
        if (recurse) {
            url.append("?recurse=true");
        }
        try {
            deleteStore = new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        boolean deleted = HTTPUtils.delete(deleteStore.toExternalForm(), this.gsuser, this.gspass);
        return deleted;
    }
}

