/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.manager;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.Util;
import it.geosolutions.geoserver.rest.decoder.RESTStyle;
import it.geosolutions.geoserver.rest.decoder.RESTStyleList;
import it.geosolutions.geoserver.rest.encoder.GSStyleEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTAbstractManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GeoServerRESTStyleManager
extends GeoServerRESTAbstractManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerRESTStyleManager.class);

    public GeoServerRESTStyleManager(URL restURL, String username, String password) throws IllegalArgumentException {
        super(restURL, username, password);
    }

    public boolean existsStyle(String name) throws RuntimeException {
        return this.existsStyle(name, true);
    }

    public boolean existsStyle(String name, boolean quietOnNotFound) {
        String url = this.buildXmlUrl(null, name);
        String composed = Util.appendQuietOnNotFound(quietOnNotFound, url);
        return HTTPUtils.exists(composed, this.gsuser, this.gspass);
    }

    public RESTStyleList getStyles() {
        String url = "/rest/styles.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Styles list from " + url);
        }
        String response = HTTPUtils.get(this.gsBaseUrl + url, this.gsuser, this.gspass);
        return RESTStyleList.build(response);
    }

    public RESTStyle getStyle(String name) {
        String url = this.buildXmlUrl(null, name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Style " + name + " from " + url);
        }
        String response = HTTPUtils.get(url, this.gsuser, this.gspass);
        return RESTStyle.build(response);
    }

    public String getSLD(String styleName) {
        String url = this.buildUrl(null, styleName, ".sld");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving SLD body from " + url);
        }
        return HTTPUtils.get(url, this.gsuser, this.gspass);
    }

    public boolean existsStyle(String workspace, String name) {
        return this.existsStyle(workspace, name, true);
    }

    public boolean existsStyle(String workspace, String name, boolean quietOnNotFound) {
        String url = this.buildXmlUrl(workspace, name);
        String composed = Util.appendQuietOnNotFound(quietOnNotFound, url);
        return HTTPUtils.exists(composed, this.gsuser, this.gspass);
    }

    public RESTStyleList getStyles(String workspace) {
        String url = "/rest/workspaces/" + HTTPUtils.enc(workspace) + "/styles.xml";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Styles list from " + url);
        }
        String response = HTTPUtils.get(this.gsBaseUrl + url, this.gsuser, this.gspass);
        return RESTStyleList.build(response);
    }

    public RESTStyle getStyle(String workspace, String name) {
        String url = this.buildXmlUrl(workspace, name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving Style " + name + " from " + url);
        }
        String response = HTTPUtils.get(url, this.gsuser, this.gspass);
        return RESTStyle.build(response);
    }

    public String getSLD(String workspace, String name) {
        String url = this.buildUrl(workspace, name, ".sld");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Retrieving SLD body from " + url);
        }
        return HTTPUtils.get(url, this.gsuser, this.gspass);
    }

    public boolean publishStyle(String sldBody) {
        try {
            return this.publishStyle(sldBody, null);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyle(String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        String sUrl = this.buildPostUrl(null, name);
        String result = HTTPUtils.post(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyle(File sldFile) {
        return this.publishStyle(sldFile, null);
    }

    public boolean publishStyle(File sldFile, String name) {
        String sUrl = this.buildPostUrl(null, name);
        LOGGER.debug("POSTing new style " + name + " to " + sUrl);
        String result = HTTPUtils.post(sUrl, sldFile, GeoServerRESTPublisher.Format.SLD.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyle(String sldBody, String name, boolean raw) {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        StringBuilder sUrl = new StringBuilder(this.buildPostUrl(null, name));
        Util.appendParameter(sUrl, "raw", "" + raw);
        String contentType = GeoServerRESTPublisher.Format.SLD.getContentType();
        if (!this.checkSLD10Version(sldBody)) {
            contentType = GeoServerRESTPublisher.Format.SLD_1_1_0.getContentType();
        }
        LOGGER.debug("POSTing new style " + name + " to " + sUrl + " using version: " + contentType);
        String result = HTTPUtils.post(sUrl.toString(), sldBody, contentType, this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyle(File sldFile, String name, boolean raw) {
        StringBuilder sUrl = new StringBuilder(this.buildPostUrl(null, name));
        Util.appendParameter(sUrl, "raw", "" + raw);
        String contentType = GeoServerRESTPublisher.Format.SLD.getContentType();
        if (!this.checkSLD10Version(sldFile)) {
            contentType = GeoServerRESTPublisher.Format.SLD_1_1_0.getContentType();
        }
        LOGGER.debug("POSTing new style " + name + " to " + sUrl + " using version: " + contentType);
        String result = HTTPUtils.post(sUrl.toString(), sldFile, contentType, this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(File sldFile, String name, boolean raw) throws IllegalArgumentException {
        if (sldFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        StringBuilder sUrl = new StringBuilder(this.buildUrl(null, name, null));
        Util.appendParameter(sUrl, "raw", "" + raw);
        String contentType = GeoServerRESTPublisher.Format.SLD.getContentType();
        if (!this.checkSLD10Version(sldFile)) {
            contentType = GeoServerRESTPublisher.Format.SLD_1_1_0.getContentType();
        }
        LOGGER.debug("PUTting style " + name + " to " + sUrl + " using version: " + contentType);
        String result = HTTPUtils.put(sUrl.toString(), sldFile, contentType, this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(String sldBody, String name, boolean raw) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        StringBuilder sUrl = new StringBuilder(this.buildUrl(null, name, null));
        Util.appendParameter(sUrl, "raw", "" + raw);
        String contentType = GeoServerRESTPublisher.Format.SLD.getContentType();
        if (!this.checkSLD10Version(sldBody)) {
            contentType = GeoServerRESTPublisher.Format.SLD_1_1_0.getContentType();
        }
        LOGGER.debug("PUTting style " + name + " to " + sUrl + " using version: " + contentType);
        String result = HTTPUtils.put(sUrl.toString(), sldBody, contentType, this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(null, name, null);
        String result = HTTPUtils.put(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyle(File sldFile, String name) throws IllegalArgumentException {
        if (sldFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(null, name, null);
        String result = HTTPUtils.put(sUrl, sldFile, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeStyle(String styleName, boolean purge) throws IllegalArgumentException {
        if (styleName == null || styleName.isEmpty()) {
            throw new IllegalArgumentException("Check styleName parameter, it may never be null or empty");
        }
        if (styleName.contains(":")) {
            LOGGER.warn("Style name is going to be changed [" + styleName + "]");
        }
        styleName = styleName.replaceAll(":", "_");
        String sUrl = this.buildUrl(null, styleName, null);
        if (purge) {
            sUrl = sUrl + "?purge=true";
        }
        return HTTPUtils.delete(sUrl, this.gsuser, this.gspass);
    }

    public boolean removeStyle(String styleName) {
        try {
            return this.removeStyle(styleName, true);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody) {
        try {
            return this.publishStyleInWorkspace(workspace, sldBody, null);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean publishStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        String sUrl = this.buildPostUrl(workspace, name);
        String result = HTTPUtils.post(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile) {
        return this.publishStyleInWorkspace(workspace, sldFile, null);
    }

    public boolean publishStyleInWorkspace(String workspace, File sldFile, String name) {
        String sUrl = this.buildPostUrl(workspace, name);
        LOGGER.debug("POSTing new style " + name + " to " + sUrl);
        String result = HTTPUtils.post(sUrl, sldFile, GeoServerRESTPublisher.Format.SLD.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean publishStyleZippedInWorkspace(String workspace, File zipFile, String name) {
        String sUrl = this.buildPostUrl(workspace, name);
        LOGGER.debug("POSTing new style " + name + " to " + sUrl);
        String result = HTTPUtils.post(sUrl, zipFile, GeoServerRESTPublisher.Format.ZIP.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String workspace, String sldBody, String name) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.put(sUrl, sldBody, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String sldBody, String workspace, String name, boolean raw) throws IllegalArgumentException {
        if (sldBody == null || sldBody.isEmpty()) {
            throw new IllegalArgumentException("The style body may not be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        StringBuilder sUrl = new StringBuilder(this.buildUrl(workspace, name, null));
        Util.appendParameter(sUrl, "raw", "" + raw);
        String contentType = GeoServerRESTPublisher.Format.SLD.getContentType();
        if (!this.checkSLD10Version(sldBody)) {
            contentType = GeoServerRESTPublisher.Format.SLD_1_1_0.getContentType();
        }
        LOGGER.debug("PUTting style " + name + " to " + sUrl + " using version: " + contentType);
        String result = HTTPUtils.put(sUrl.toString(), sldBody, contentType, this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String workspace, File sldFile, String name) throws IllegalArgumentException {
        if (sldFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.put(sUrl, sldFile, "application/vnd.ogc.sld+xml", this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleInWorkspace(String workspace, GSStyleEncoder encoder, String name) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter encoder");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.putXml(sUrl, encoder.toString(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean updateStyleZippedInWorkspace(String workspace, File zipFile, String name) throws IllegalArgumentException {
        if (zipFile == null) {
            throw new IllegalArgumentException("Unable to updateStyle using a null parameter file");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The style name may not be null or empty");
        }
        String sUrl = this.buildUrl(workspace, name, null);
        String result = HTTPUtils.put(sUrl, zipFile, GeoServerRESTPublisher.Format.ZIP.getContentType(), this.gsuser, this.gspass);
        return result != null;
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName, boolean purge) throws IllegalArgumentException {
        if (styleName == null || styleName.isEmpty()) {
            throw new IllegalArgumentException("Check styleName parameter, it may never be null or empty");
        }
        if (styleName.contains(":")) {
            LOGGER.warn("Style name is going to be changed [" + styleName + "]");
        }
        styleName = styleName.replaceAll(":", "_");
        String sUrl = this.buildUrl(workspace, styleName, null);
        if (purge) {
            sUrl = sUrl + "?purge=true";
        }
        return HTTPUtils.delete(sUrl, this.gsuser, this.gspass);
    }

    public boolean removeStyleInWorkspace(String workspace, String styleName) {
        try {
            return this.removeStyleInWorkspace(workspace, styleName, true);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
    }

    protected String buildPostUrl(String workspace, String name) {
        StringBuilder sUrl = new StringBuilder(this.gsBaseUrl.toString()).append("/rest");
        if (workspace != null) {
            sUrl.append("/workspaces/").append(HTTPUtils.enc(workspace));
        }
        sUrl.append("/styles");
        if (name != null && !name.isEmpty()) {
            sUrl.append("?name=").append(HTTPUtils.enc(name));
        }
        return sUrl.toString();
    }

    protected String buildXmlUrl(String workspace, String name) {
        return this.buildUrl(workspace, name, ".xml");
    }

    protected String buildUrl(String workspace, String name, String ext) {
        StringBuilder sUrl = new StringBuilder(this.gsBaseUrl.toString()).append("/rest");
        if (workspace != null) {
            sUrl.append("/workspaces/").append(HTTPUtils.enc(workspace));
        }
        sUrl.append("/styles/").append(HTTPUtils.enc(name));
        if (ext != null) {
            sUrl.append(ext);
        }
        return sUrl.toString();
    }

    private boolean checkSLD10Version(String sldBody) {
        boolean result = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(sldBody.getBytes(Charset.forName("UTF-8")));
            Document doc = builder.parse(stream);
            result = this.checkSLD10Version(doc);
        }
        catch (SAXException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        return result;
    }

    private boolean checkSLD10Version(File fileSLD) {
        boolean result = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileSLD);
            result = this.checkSLD10Version(doc);
        }
        catch (SAXException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        return result;
    }

    private boolean checkSLD10Version(Document doc) {
        boolean result = false;
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//@version='1.0.0'");
            result = (Boolean)expr.evaluate(doc, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            LOGGER.error("Error parsing SLD file: " + ex);
        }
        return result;
    }
}

