/*
 * Decompiled with CFR 0.152.
 */
package marvin.color;

import marvin.image.MarvinImage;

public class MarvinColorModelConverter {
    public static MarvinImage rgbToBinary(MarvinImage img, int threshold) {
        MarvinImage resultImage = new MarvinImage(img.getWidth(), img.getHeight(), 1);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int gray = (int)((double)img.getIntComponent0(x, y) * 0.3 + (double)img.getIntComponent1(x, y) * 0.59 + (double)img.getIntComponent2(x, y) * 0.11);
                if (gray <= threshold) {
                    resultImage.setBinaryColor(x, y, true);
                    continue;
                }
                resultImage.setBinaryColor(x, y, false);
            }
        }
        return resultImage;
    }

    public static MarvinImage binaryToRgb(MarvinImage img) {
        MarvinImage resultImage = new MarvinImage(img.getWidth(), img.getHeight(), 0);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                if (img.getBinaryColor(x, y)) {
                    resultImage.setIntColor(x, y, 255, 0, 0, 0);
                    continue;
                }
                resultImage.setIntColor(x, y, 255, 255, 255, 255);
            }
        }
        return resultImage;
    }

    public static int[] binaryToRgb(boolean[] binaryArray) {
        int[] rgbArray = new int[binaryArray.length];
        for (int i = 0; i < binaryArray.length; ++i) {
            rgbArray[i] = binaryArray[i] ? -16777216 : -1;
        }
        return rgbArray;
    }

    public static double[] rgbToHsv(int[] rgbArray) {
        double[] hsvArray = new double[rgbArray.length * 3];
        for (int i = 0; i < rgbArray.length; ++i) {
            double min;
            double c;
            double red = (rgbArray[i] & 0xFF0000) >> 16;
            double green = (rgbArray[i] & 0xFF00) >> 8;
            double blue = rgbArray[i] & 0xFF;
            double max = Math.max(Math.max(red /= 255.0, green /= 255.0), blue /= 255.0);
            double h = (c = max - (min = Math.min(Math.min(red, green), blue))) != 0.0 ? (max == red ? (green >= blue ? 60.0 * ((green - blue) / c) : 60.0 * ((green - blue) / c) + 360.0) : (max == green ? 60.0 * ((blue - red) / c) + 120.0 : 60.0 * ((red - green) / c) + 240.0)) : 0.0;
            double v = max;
            double s = c != 0.0 ? c / v : 0.0;
            hsvArray[i * 3] = h;
            hsvArray[i * 3 + 1] = s;
            hsvArray[i * 3 + 2] = v;
        }
        return hsvArray;
    }

    public static int[] hsvToRgb(double[] hsvArray) {
        int[] rgbArray = new int[hsvArray.length / 3];
        int i = 0;
        int j = 0;
        while (i < hsvArray.length) {
            double h = hsvArray[i];
            double s = hsvArray[i + 1];
            double v = hsvArray[i + 2];
            double hi = (int)(h / 60.0 % 6.0);
            double f = h / 60.0 - hi;
            double p = v * (1.0 - s);
            double q = v * (1.0 - f * s);
            double t = v * (1.0 - (1.0 - f) * s);
            int iHi = (int)hi;
            int r = 0;
            int g = 0;
            int b = 0;
            switch (iHi) {
                case 0: {
                    r = (int)(v * 255.0);
                    g = (int)(t * 255.0);
                    b = (int)(p * 255.0);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0);
                    g = (int)(v * 255.0);
                    b = (int)(p * 255.0);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0);
                    g = (int)(v * 255.0);
                    b = (int)(t * 255.0);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0);
                    g = (int)(q * 255.0);
                    b = (int)(v * 255.0);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0);
                    g = (int)(p * 255.0);
                    b = (int)(v * 255.0);
                    break;
                }
                case 5: {
                    r = (int)(v * 255.0);
                    g = (int)(p * 255.0);
                    b = (int)(q * 255.0);
                }
            }
            rgbArray[j] = -16777216 + (r << 16) + (g << 8) + b;
            i += 3;
            ++j;
        }
        return rgbArray;
    }
}

