/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import marvin.image.MarvinImage;
import marvin.util.MarvinPluginHistory;

public class MarvinImagePanel
extends JPanel {
    protected MarvinImage image;
    protected MarvinPluginHistory history;
    private boolean fitSizeToImage = true;
    private int width;
    private int height;

    public void enableHistory() {
        this.history = new MarvinPluginHistory();
    }

    public void disableHistory() {
        this.history = null;
    }

    public boolean isHistoryEnabled() {
        return this.history != null;
    }

    public MarvinPluginHistory getHistory() {
        return this.history;
    }

    @Override
    public Image createImage(int width, int height) {
        this.image = new MarvinImage(width, height);
        this.setPreferredSize(new Dimension(width, height));
        return this.image.getBufferedImage();
    }

    public void setImage(MarvinImage img) {
        img.update();
        this.image = img;
        if (this.fitSizeToImage && img != null && this.width != this.image.getWidth() && this.height != this.image.getHeight()) {
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            Dimension d = new Dimension(this.width, this.height);
            this.setSize(d);
            this.setPreferredSize(d);
            this.validate();
        }
        this.repaint();
    }

    public MarvinImage getImage() {
        return this.image;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image.getBufferedImage(), 0, 0, this);
        }
    }

    public void update() {
        this.image.update();
        this.repaint();
    }
}

