/*
 * Decompiled with CFR 0.152.
 */
package marvin.gui.component;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class MarvinMatrixPanel
extends JPanel {
    private JFormattedTextField[][] textFields;
    private int rows;
    private int columns;

    public MarvinMatrixPanel(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        JPanel panelTextFields = new JPanel();
        GridLayout layout = new GridLayout(rows, columns);
        panelTextFields.setLayout(layout);
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormatSymbols dfs = decimalFormat.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(dfs);
        this.textFields = new JFormattedTextField[rows][columns];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                this.textFields[r][c] = new JFormattedTextField(decimalFormat);
                this.textFields[r][c].setValue(0.0);
                this.textFields[r][c].setColumns(4);
                panelTextFields.add(this.textFields[r][c]);
            }
        }
        this.setLayout(new FlowLayout(1));
        this.add(panelTextFields);
    }

    public double[][] getValue() {
        double[][] result = new double[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                result[r][c] = Double.parseDouble(this.textFields[r][c].getText());
            }
        }
        return result;
    }
}

