/*
 * Decompiled with CFR 0.152.
 */
package marvin.image;

import marvin.image.MarvinContour;

public class MarvinBlob {
    private int width;
    private int height;
    private int area;
    private boolean[][] pixels;

    public MarvinBlob(int width, int height) {
        this.width = width;
        this.height = height;
        this.area = 0;
        this.pixels = new boolean[width][height];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setValue(int x, int y, boolean value) {
        if (!this.pixels[x][y] && value) {
            ++this.area;
        } else if (this.pixels[x][y] && !value) {
            --this.area;
        }
        this.pixels[x][y] = value;
    }

    public int getArea() {
        return this.area;
    }

    public boolean getValue(int x, int y) {
        return this.pixels[x][y];
    }

    public MarvinContour toContour() {
        MarvinContour contour = new MarvinContour();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!this.getValue(x, y) || x - 1 >= 0 && x + 1 != this.width && y - 1 >= 0 && y + 1 != this.height && this.getValue(x - 1, y - 1) && this.getValue(x - 1, y) && this.getValue(x - 1, y + 1) && this.getValue(x, y - 1) && this.getValue(x, y + 1) && this.getValue(x + 1, y - 1) && this.getValue(x + 1, y) && this.getValue(x + 1, y + 1)) continue;
                contour.addPoint(x, y);
            }
        }
        return contour;
    }
}

